/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.deployment;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.deployment.Artifact;
import org.wso2.carbon.kernel.deployment.ArtifactType;
import org.wso2.carbon.kernel.internal.deployment.DeploymentEngine;
import org.wso2.carbon.kernel.internal.deployment.Utils;

public class RepositoryScanner {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryScanner.class);
    private final DeploymentEngine carbonDeploymentEngine;
    private List<Artifact> artifactsToDeploy = new ArrayList<Artifact>();
    private List<Artifact> artifactsToUndeploy = new ArrayList<Artifact>();
    private List<Artifact> artifactsToUpdate = new ArrayList<Artifact>();
    private List<String> artifactFilePathList = new ArrayList<String>();

    public RepositoryScanner(DeploymentEngine carbonDeploymentEngine) {
        this.carbonDeploymentEngine = carbonDeploymentEngine;
    }

    public void scan() {
        logger.debug("Starting scanning of deployer directories");
        this.mark();
        this.sweep();
    }

    private void mark() {
        File carbonRepo = this.carbonDeploymentEngine.getRepositoryDirectory();
        this.carbonDeploymentEngine.getDeployers().values().forEach(deployer -> {
            File deploymentLocation = Utils.resolveFileURL(deployer.getLocation().getPath(), carbonRepo.getPath());
            this.findArtifactsToDeploy(deploymentLocation, deployer.getArtifactType());
        });
        this.checkUndeployedArtifacts();
    }

    private void sweep() {
        if (this.artifactsToUpdate.size() > 0) {
            try {
                this.carbonDeploymentEngine.updateArtifacts(this.artifactsToUpdate);
            }
            finally {
                this.artifactsToUpdate.clear();
            }
        }
        if (this.artifactsToUndeploy.size() > 0) {
            try {
                this.carbonDeploymentEngine.undeployArtifacts(this.artifactsToUndeploy);
            }
            finally {
                this.artifactsToUndeploy.clear();
            }
        }
        if (this.artifactsToDeploy.size() > 0) {
            try {
                this.carbonDeploymentEngine.deployArtifacts(this.artifactsToDeploy);
            }
            finally {
                this.artifactsToDeploy.clear();
            }
        }
    }

    private void findArtifactsToDeploy(File directoryToSearch, ArtifactType type) {
        File[] files = directoryToSearch.listFiles();
        if (files != null && files.length > 0) {
            Arrays.asList(files).forEach(file -> {
                Artifact artifact = new Artifact((File)file);
                artifact.setType(type);
                this.addArtifactToDeploy(artifact);
            });
        }
    }

    private void addArtifactToDeploy(Artifact artifact) {
        Artifact deployedArtifact = this.findDeployedArtifact(artifact.getType(), artifact.getPath());
        if (deployedArtifact != null) {
            if (Utils.isArtifactModified(deployedArtifact)) {
                this.artifactsToUpdate.add(deployedArtifact);
            }
        } else {
            this.artifactsToDeploy.add(artifact);
            Utils.setArtifactLastModifiedTime(artifact);
        }
        this.artifactFilePathList.add(artifact.getPath());
    }

    private Artifact findDeployedArtifact(ArtifactType type, String path) {
        Artifact faultyArtifact = this.carbonDeploymentEngine.getFaultyArtifacts().get(path);
        if (faultyArtifact != null && !Utils.isArtifactModified(faultyArtifact)) {
            return faultyArtifact;
        }
        Map<ArtifactType, ConcurrentHashMap<Object, Artifact>> deployedArtifacts = this.carbonDeploymentEngine.getDeployedArtifacts();
        if (deployedArtifacts.get(type) == null) {
            return null;
        }
        return deployedArtifacts.get(type).values().stream().filter(artifact -> path.equals(artifact.getPath())).findAny().orElse(null);
    }

    private void checkUndeployedArtifacts() {
        this.artifactsToUndeploy = this.carbonDeploymentEngine.getDeployedArtifacts().values().stream().flatMap(artifactMap -> artifactMap.values().stream()).filter(artifact -> this.artifactFilePathList.stream().noneMatch(path -> path.equals(artifact.getPath()))).collect(Collectors.toList());
        this.artifactFilePathList.clear();
    }
}

