/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.runtime;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.runtime.CarbonRuntimeService;
import org.wso2.carbon.kernel.internal.runtime.RuntimeManager;
import org.wso2.carbon.kernel.runtime.Runtime;
import org.wso2.carbon.kernel.runtime.RuntimeService;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;

@Component(name="org.wso2.carbon.kernel.internal.runtime.RuntimeServiceListenerComponent", immediate=true, property={"capability-name=org.wso2.carbon.kernel.runtime.Runtime", "component-key=carbon-runtime-mgt"})
public class RuntimeServiceListenerComponent
implements RequiredCapabilityListener {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeServiceListenerComponent.class);
    private RuntimeManager runtimeManager = new RuntimeManager();
    private BundleContext bundleContext;

    @Activate
    protected void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        DataHolder.getInstance().setRuntimeManager(this.runtimeManager);
    }

    @Reference(name="carbon.runtime.service", service=Runtime.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterRuntime")
    protected void registerRuntime(Runtime runtime) {
        try {
            this.runtimeManager.registerRuntime(runtime);
        }
        catch (Exception e) {
            logger.error("Error while adding runtime to the Runtime manager", e);
        }
    }

    protected void unRegisterRuntime(Runtime runtime) {
        try {
            this.runtimeManager.unRegisterRuntime(runtime);
        }
        catch (Exception e) {
            logger.error("Error while removing runtime from Runtime manager", e);
        }
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering RuntimeService as an OSGi service");
        }
        CarbonRuntimeService runtimeService = new CarbonRuntimeService(this.runtimeManager);
        this.bundleContext.registerService(RuntimeService.class, (Object)runtimeService, null);
    }
}

