/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;

public class NettyTransportDataHolder {
    private static final Logger log = LoggerFactory.getLogger(NettyTransportDataHolder.class);
    private static NettyTransportDataHolder instance = new NettyTransportDataHolder();
    private Map<String, CarbonNettyServerInitializer> channelInitializers = new HashMap<String, CarbonNettyServerInitializer>();
    private BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private NettyTransportDataHolder() {
    }

    public static NettyTransportDataHolder getInstance() {
        return instance;
    }

    public synchronized void addNettyChannelInitializer(String key, CarbonNettyServerInitializer initializer) {
        if (this.channelInitializers.get(key) == null) {
            this.channelInitializers.put(key, initializer);
        } else {
            log.error("Netty transport listener " + key + " already registered");
        }
    }

    public CarbonNettyServerInitializer getChannelInitializer(String key) {
        return this.channelInitializers.get(key);
    }

    public void removeNettyChannelInitializer(String key) {
        this.channelInitializers.remove(key);
    }
}

