/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.transports.TransportManager;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportDataHolder;
import org.wso2.carbon.transport.http.netty.internal.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.internal.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.internal.config.YAMLTransportConfigurationBuilder;
import org.wso2.carbon.transport.http.netty.listener.NettyListener;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.internal.MSF4JNettyServerInitializer;
import org.wso2.msf4j.internal.MicroservicesRegistry;

public class MicroservicesRunner {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesRunner.class);
    private TransportManager transportManager = new TransportManager();
    private long startTime = System.currentTimeMillis();
    private boolean isStarted;
    private MicroservicesRegistry msRegistry = MicroservicesRegistry.newInstance();

    public MicroservicesRunner(int ... ports) {
        for (int port : ports) {
            NettyTransportDataHolder nettyTransportDataHolder = NettyTransportDataHolder.getInstance();
            ListenerConfiguration listenerConfiguration = new ListenerConfiguration("netty-" + port, "0.0.0.0", port);
            NettyListener listener = new NettyListener(listenerConfiguration);
            this.transportManager.registerTransport(listener);
            nettyTransportDataHolder.addNettyChannelInitializer(listenerConfiguration.getId(), new MSF4JNettyServerInitializer(this.msRegistry));
        }
    }

    public MicroservicesRunner() {
        TransportsConfiguration trpConfig = YAMLTransportConfigurationBuilder.build();
        Set<ListenerConfiguration> listenerConfigurations = trpConfig.getListenerConfigurations();
        NettyTransportDataHolder nettyTransportDataHolder = NettyTransportDataHolder.getInstance();
        for (ListenerConfiguration listenerConfiguration : listenerConfigurations) {
            NettyListener listener = new NettyListener(listenerConfiguration);
            this.transportManager.registerTransport(listener);
            nettyTransportDataHolder.addNettyChannelInitializer(listenerConfiguration.getId(), new MSF4JNettyServerInitializer(this.msRegistry));
        }
    }

    public MicroservicesRunner deploy(Object microservice) {
        this.checkState();
        this.msRegistry.addHttpService(microservice);
        return this;
    }

    public MicroservicesRunner addInterceptor(Interceptor interceptor) {
        this.checkState();
        this.msRegistry.addInterceptor(interceptor);
        return this;
    }

    private void checkState() {
        if (this.isStarted) {
            throw new IllegalStateException("Microservices runner already started");
        }
    }

    public void start() {
        this.handleServiceLifecycleMethods();
        this.transportManager.startTransports();
        this.isStarted = true;
        log.info("Microservices server started in " + (System.currentTimeMillis() - this.startTime) + "ms");
    }

    public void stop() {
        this.transportManager.stopTransports();
        log.info("Microservices server stopped");
    }

    public MicroservicesRegistry getMsRegistry() {
        return this.msRegistry;
    }

    private void handleServiceLifecycleMethods() {
        this.msRegistry.initServices();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MicroservicesRunner.this.msRegistry.preDestroyServices();
            }
        });
    }
}

