/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.transports.CarbonTransport;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;
import org.wso2.msf4j.internal.MSF4JNettyServerInitializer;
import org.wso2.msf4j.internal.MicroservicesRegistry;

public class DataHolder {
    private static final Logger log = LoggerFactory.getLogger(DataHolder.class);
    private static final String CHANNEL_ID_KEY = "channel.id";
    private static DataHolder instance = new DataHolder();
    private BundleContext bundleContext;
    private Map<String, ServiceRegistration<CarbonNettyServerInitializer>> carbonTransports = new HashMap<String, ServiceRegistration<CarbonNettyServerInitializer>>();

    private DataHolder() {
    }

    public static DataHolder getInstance() {
        return instance;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void addCarbonTransport(CarbonTransport carbonTransport) {
        if (this.bundleContext == null) {
            log.error("BundleContext is null. Transport dispatching will fail.");
            return;
        }
        String channelKey = carbonTransport.getId();
        Hashtable<String, String> httpInitParams = new Hashtable<String, String>();
        httpInitParams.put(CHANNEL_ID_KEY, channelKey);
        MSF4JNettyServerInitializer gatewayNettyInitializer = new MSF4JNettyServerInitializer(MicroservicesRegistry.getInstance());
        ServiceRegistration service = this.bundleContext.registerService(CarbonNettyServerInitializer.class, (Object)gatewayNettyInitializer, httpInitParams);
        this.carbonTransports.put(channelKey, (ServiceRegistration<CarbonNettyServerInitializer>)service);
    }

    public void removeCarbonTransport(CarbonTransport carbonTransport) {
        this.carbonTransports.get(carbonTransport.getId()).unregister();
    }
}

