/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Map;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;
import org.wso2.msf4j.internal.MicroservicesRegistry;
import org.wso2.msf4j.internal.router.HttpDispatcher;
import org.wso2.msf4j.internal.router.RequestRouter;

public class MSF4JNettyServerInitializer
implements CarbonNettyServerInitializer {
    private DefaultEventExecutorGroup eventExecutorGroup;
    private MicroservicesRegistry microservicesRegistry;

    public MSF4JNettyServerInitializer(MicroservicesRegistry microservicesRegistry) {
        this.microservicesRegistry = microservicesRegistry;
    }

    @Override
    public void setup(Map<String, String> map) {
        this.eventExecutorGroup = new DefaultEventExecutorGroup(Integer.parseInt(map.get("execThreadPoolSize")));
    }

    @Override
    public void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
        pipeline.addLast("streamer", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("router", (ChannelHandler)new RequestRouter(this.microservicesRegistry.getHttpResourceHandler(), 0));
        pipeline.addLast((EventExecutorGroup)this.eventExecutorGroup, "dispatcher", (ChannelHandler)new HttpDispatcher());
    }
}

