/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.internal.MicroservicesLCException;
import org.wso2.msf4j.internal.router.ExceptionHandler;
import org.wso2.msf4j.internal.router.MicroserviceMetadata;
import org.wso2.msf4j.internal.router.URLRewriter;

public class MicroservicesRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(MicroservicesRegistry.class);
    private static final MicroservicesRegistry instance = new MicroservicesRegistry();
    private final Set<Object> httpServices = new HashSet<Object>();
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private URLRewriter urlRewriter = null;
    private volatile MicroserviceMetadata httpResourceHandler = new MicroserviceMetadata(Collections.emptyList(), this.interceptors, this.urlRewriter, new ExceptionHandler());

    private MicroservicesRegistry() {
    }

    public static MicroservicesRegistry getInstance() {
        return instance;
    }

    public static MicroservicesRegistry newInstance() {
        return new MicroservicesRegistry();
    }

    public void addHttpService(Object httpHandler) {
        this.httpServices.add(httpHandler);
        this.updateHttpResourceHandler();
        LOG.info("Added microservice: " + httpHandler);
    }

    public void removeHttpService(Object httpService) {
        this.httpServices.remove(httpService);
        this.updateHttpResourceHandler();
    }

    public MicroserviceMetadata getHttpResourceHandler() {
        return this.httpResourceHandler;
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        this.updateHttpResourceHandler();
    }

    public void removeInterceptor(Interceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.updateHttpResourceHandler();
    }

    public void setUrlRewriter(URLRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
        this.updateHttpResourceHandler();
    }

    public int getServiceCount() {
        return this.httpServices.size();
    }

    private void updateHttpResourceHandler() {
        this.httpResourceHandler = new MicroserviceMetadata(Collections.unmodifiableSet(this.httpServices), this.interceptors, this.urlRewriter, new ExceptionHandler());
    }

    public void initServices() {
        this.invokeLifecycleMethods(PostConstruct.class);
    }

    public void initService(Object httpService) {
        this.invokeLifecycleMethod(httpService, PostConstruct.class);
    }

    public void preDestroyServices() {
        this.invokeLifecycleMethods(PreDestroy.class);
    }

    public void preDestroyService(Object httpService) {
        this.invokeLifecycleMethod(httpService, PreDestroy.class);
    }

    private void invokeLifecycleMethods(Class lcAnnotation) {
        this.httpServices.stream().forEach(httpService -> this.invokeLifecycleMethod(httpService, lcAnnotation));
    }

    private void invokeLifecycleMethod(Object httpService, Class lcAnnotation) {
        Optional<Method> lcMethod = Optional.ofNullable(this.getLifecycleMethod(httpService, lcAnnotation));
        if (lcMethod.isPresent()) {
            try {
                lcMethod.get().invoke(httpService, null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new MicroservicesLCException("Exception occurs calling lifecycle method", e);
            }
        }
    }

    private Method getLifecycleMethod(Object httpService, Class lcAnnotation) {
        return Arrays.stream(httpService.getClass().getDeclaredMethods()).filter(m -> this.isValidLifecycleMethod(Optional.of(m), lcAnnotation)).findFirst().orElse(null);
    }

    private boolean isValidLifecycleMethod(Optional<Method> method, Class lcAnnotation) {
        return method.filter(m -> Modifier.isPublic(m.getModifiers()) && m.getAnnotation(lcAnnotation) != null).isPresent();
    }
}

