/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import io.netty.handler.codec.http.HttpRequest;
import java.util.List;
import java.util.Map;
import org.wso2.msf4j.HttpResponder;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpMethodInfo;
import org.wso2.msf4j.internal.router.HttpResourceModel;
import org.wso2.msf4j.internal.router.HttpResourceModelProcessor;

public class HttpMethodInfoBuilder {
    private HttpResourceModel httpResourceModel;
    private HttpRequest request;
    private HttpResponder responder;
    private Map<String, String> groupValues;
    private String contentType;
    private List<String> acceptTypes;
    private HttpMethodInfo httpMethodInfo;

    public static HttpMethodInfoBuilder getInstance() {
        HttpMethodInfoBuilder httpMethodInfoBuilder = new HttpMethodInfoBuilder();
        return httpMethodInfoBuilder;
    }

    public HttpMethodInfoBuilder httpResourceModel(HttpResourceModel httpResourceModel) {
        this.httpResourceModel = httpResourceModel;
        return this;
    }

    public HttpMethodInfoBuilder httpRequest(HttpRequest request) {
        this.request = request;
        return this;
    }

    public HttpMethodInfoBuilder httpResponder(HttpResponder responder) {
        this.responder = responder;
        return this;
    }

    public HttpMethodInfoBuilder requestInfo(Map<String, String> groupValues, String contentType, List<String> acceptTypes) {
        this.groupValues = groupValues;
        this.contentType = contentType;
        this.acceptTypes = acceptTypes;
        return this;
    }

    public HttpMethodInfo build() throws HandlerException {
        if (this.httpMethodInfo == null) {
            this.httpMethodInfo = new HttpResourceModelProcessor(this.httpResourceModel).buildHttpMethodInfo(this.request, this.responder, this.groupValues, this.contentType, this.acceptTypes);
        }
        return this.httpMethodInfo;
    }

    public HttpResourceModel getHttpResourceModel() {
        return this.httpResourceModel;
    }

    public HttpResponder getResponder() {
        return this.responder;
    }

    public HttpRequest getRequest() {
        return this.request;
    }
}

