/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.security;

import com.google.common.collect.ArrayListMultimap;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.msf4j.HttpResponder;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.util.SystemVariableUtil;

public class JWTSecurityInterceptor
implements Interceptor {
    private final Log log = LogFactory.getLog(JWTSecurityInterceptor.class);
    private static final String JWT_HEADER = "X-JWT-Assertion";
    private static final String AUTH_TYPE_JWT = "JWT";
    private static final String KEYSTORE = SystemVariableUtil.getValue("PETSTORE_KEYSTORE", "wso2carbon.jks");
    private static final String ALIAS = SystemVariableUtil.getValue("PETSTORE_KEY_ALIAS", "wso2carbon");
    private static final String KEYSTORE_PASSWORD = SystemVariableUtil.getValue("PETSTORE_KEYSTORE_PASS", "wso2carbon");

    @Override
    public boolean preCall(HttpRequest request, HttpResponder responder, ServiceMethodInfo serviceMethodInfo) {
        boolean isValidSignature;
        String jwtHeader;
        HttpHeaders headers = request.headers();
        if (headers != null && (jwtHeader = headers.get(JWT_HEADER)) != null && (isValidSignature = this.verifySignature(jwtHeader))) {
            return true;
        }
        ArrayListMultimap<String, String> map = ArrayListMultimap.create();
        map.put("WWW-Authenticate", AUTH_TYPE_JWT);
        responder.sendStatus(HttpResponseStatus.UNAUTHORIZED, map);
        return false;
    }

    @Override
    public void postCall(HttpRequest request, HttpResponseStatus status, ServiceMethodInfo serviceMethodInfo) {
    }

    private boolean verifySignature(String jwt) {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)jwt);
            if (new Date().before(signedJWT.getJWTClaimsSet().getExpirationTime())) {
                RSASSAVerifier verifier = new RSASSAVerifier((RSAPublicKey)this.getPublicKey(KEYSTORE, KEYSTORE_PASSWORD, ALIAS));
                return signedJWT.verify((JWSVerifier)verifier);
            }
            this.log.info("Token has expired");
        }
        catch (JOSEException | IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | ParseException e) {
            this.log.error("Error occurred while JWT signature verification", e);
        }
        return false;
    }

    private PublicKey getPublicKey(String keyStorePath, String keyStorePassword, String alias) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(keyStorePath);){
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(inputStream, keyStorePassword.toCharArray());
            Key key = keystore.getKey(alias, keyStorePassword.toCharArray());
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
                return publicKey;
            }
        }
        return null;
    }
}

