/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.common.disruptor.config;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.PhasedBackoffWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.transport.http.netty.common.TransportThreadFactory;
import org.wso2.carbon.transport.http.netty.common.disruptor.config.DisruptorConfig;
import org.wso2.carbon.transport.http.netty.common.disruptor.event.CarbonDisruptorEvent;
import org.wso2.carbon.transport.http.netty.common.disruptor.exception.GenericExceptionHandler;
import org.wso2.carbon.transport.http.netty.common.disruptor.handler.CarbonDisruptorEventHandler;

public class DisruptorFactory {
    private static ConcurrentHashMap<DisruptorType, DisruptorConfig> disruptorConfigHashMap = new ConcurrentHashMap();

    public static void createDisruptors(DisruptorType type, DisruptorConfig disruptorConfig) {
        WaitStrategy inboundWaitStrategy = DisruptorFactory.getWaitStrategy(disruptorConfig.getDisruptorWaitStrategy());
        int externalPoolWorkerCount = disruptorConfig.getNoOfThreadsInConsumerWorkerPool();
        for (int i = 0; i < disruptorConfig.getNoDisruptors(); ++i) {
            int j;
            ExecutorService executorService = null;
            executorService = externalPoolWorkerCount > 0 ? Executors.newFixedThreadPool(disruptorConfig.getNoOfThreadsInConsumerWorkerPool(), new TransportThreadFactory(new ThreadGroup("Disruptor-Worker-Pool"))) : Executors.newFixedThreadPool(disruptorConfig.getNoOfEventHandlersPerDisruptor(), new TransportThreadFactory(new ThreadGroup("Disruptor-Worker-Pool")));
            Disruptor<CarbonDisruptorEvent> disruptor = new Disruptor<CarbonDisruptorEvent>(CarbonDisruptorEvent.EVENT_FACTORY, disruptorConfig.getBufferSize(), executorService, ProducerType.MULTI, inboundWaitStrategy);
            GenericExceptionHandler exh = new GenericExceptionHandler();
            if (externalPoolWorkerCount > 0) {
                WorkHandler[] workHandler = new WorkHandler[disruptorConfig.getNoOfEventHandlersPerDisruptor()];
                for (j = 0; j < disruptorConfig.getNoOfEventHandlersPerDisruptor(); ++j) {
                    CarbonDisruptorEventHandler carbonDisruptorEventHandler = new CarbonDisruptorEventHandler();
                    workHandler[j] = carbonDisruptorEventHandler;
                }
                disruptor.handleEventsWithWorkerPool(workHandler);
                disruptor.handleExceptionsWith(exh);
            } else {
                EventHandler[] eventHandlers = new EventHandler[disruptorConfig.getNoOfEventHandlersPerDisruptor()];
                for (j = 0; j < disruptorConfig.getNoOfEventHandlersPerDisruptor(); ++j) {
                    CarbonDisruptorEventHandler eventHandler = new CarbonDisruptorEventHandler();
                    eventHandlers[j] = eventHandler;
                }
                disruptor.handleEventsWith(eventHandlers);
                for (EventHandler eventHandler : eventHandlers) {
                    disruptor.handleExceptionsFor(eventHandler).with(exh);
                }
            }
            disruptorConfig.addDisruptor(disruptor.start());
        }
        disruptorConfigHashMap.put(type, disruptorConfig);
    }

    private static WaitStrategy getWaitStrategy(String waitstrategy) {
        WaitStrategy waitStrategy;
        switch (waitstrategy) {
            case "BLOCKING_WAIT": {
                waitStrategy = new BlockingWaitStrategy();
                break;
            }
            case "BUSY_SPIN": {
                waitStrategy = new BusySpinWaitStrategy();
                break;
            }
            case "LITE_BLOCKING": {
                waitStrategy = new LiteBlockingWaitStrategy();
                break;
            }
            case "SLEEP_WAITING": {
                waitStrategy = new SleepingWaitStrategy();
                break;
            }
            case "TIME_BLOCKING": {
                waitStrategy = new TimeoutBlockingWaitStrategy(1L, TimeUnit.SECONDS);
                break;
            }
            case "YIELD_WAITING": {
                waitStrategy = new YieldingWaitStrategy();
                break;
            }
            default: {
                waitStrategy = PhasedBackoffWaitStrategy.withLiteLock(1L, 4L, TimeUnit.SECONDS);
            }
        }
        return waitStrategy;
    }

    public static DisruptorConfig getDisruptorConfig(DisruptorType disruptorType) {
        return disruptorConfigHashMap.get((Object)disruptorType);
    }

    public static enum DisruptorType {
        INBOUND,
        OUTBOUND;

    }
}

