/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.TransportListener;
import org.wso2.carbon.messaging.TransportListenerManager;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.Parameter;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;
import org.wso2.carbon.transport.http.netty.listener.ServerBootstrapConfiguration;

public class NettyListener
extends TransportListener {
    private static final Logger log = LoggerFactory.getLogger(NettyListener.class);
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ServerBootstrap bootstrap;
    private ListenerConfiguration nettyConfig;
    private Map<Integer, ChannelFuture> channelFutureMap = new ConcurrentHashMap<Integer, ChannelFuture>();
    private Map<String, SSLConfig> sslConfigMap = new ConcurrentHashMap<String, SSLConfig>();

    public NettyListener(ListenerConfiguration nettyConfig) {
        super(nettyConfig.getId());
        this.nettyConfig = nettyConfig;
    }

    @Override
    public void start() {
        log.info("Starting Netty Http Transport Listener");
        this.startTransport();
    }

    private void startTransport() {
        ServerBootstrapConfiguration.createBootStrapConfiguration(this.nettyConfig.getParameters());
        ServerBootstrapConfiguration serverBootstrapConfiguration = ServerBootstrapConfiguration.getInstance();
        this.bossGroup = new NioEventLoopGroup(this.nettyConfig.getBossThreadPoolSize());
        this.workerGroup = new NioEventLoopGroup(this.nettyConfig.getWorkerThreadPoolSize());
        log.debug("Netty Boss group size " + this.bossGroup);
        log.debug("Netty Worker group Size" + this.workerGroup);
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.option(ChannelOption.SO_BACKLOG, serverBootstrapConfiguration.getSoBackLog());
        log.debug("Netty Server Socket BACKLOG " + serverBootstrapConfiguration.getSoBackLog());
        this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
        this.addChannelInitializer();
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, serverBootstrapConfiguration.isTcpNoDelay());
        log.debug("Netty Server Socket TCP_NODELAY " + serverBootstrapConfiguration.isTcpNoDelay());
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, serverBootstrapConfiguration.isKeepAlive());
        log.debug("Netty Server Socket SO_KEEPALIVE " + serverBootstrapConfiguration.isKeepAlive());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, serverBootstrapConfiguration.getConnectTimeOut());
        log.debug(" Netty Server Socket CONNECT_TIMEOUT_MILLIS " + serverBootstrapConfiguration.getConnectTimeOut());
        this.bootstrap.option(ChannelOption.SO_SNDBUF, serverBootstrapConfiguration.getSendBufferSize());
        log.debug("Netty Server Socket SO_SNDBUF " + serverBootstrapConfiguration.getSendBufferSize());
        this.bootstrap.option(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReciveBufferSize());
        log.debug("Netty Server Socket SO_RCVBUF " + serverBootstrapConfiguration.getReciveBufferSize());
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReciveBufferSize());
        log.debug("Netty Server Socket SO_RCVBUF " + serverBootstrapConfiguration.getReciveBufferSize());
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, serverBootstrapConfiguration.getSendBufferSize());
        log.debug("Netty Server Socket SO_SNDBUF " + serverBootstrapConfiguration.getSendBufferSize());
        try {
            ChannelFuture future = this.bootstrap.bind(new InetSocketAddress(this.nettyConfig.getHost(), this.nettyConfig.getPort())).sync();
            if (future.isSuccess()) {
                TransportListenerManager artifactDeployer = NettyTransportContextHolder.getInstance().getManager();
                if (artifactDeployer != null) {
                    artifactDeployer.registerTransportListener(this.id, this);
                }
                log.info("Netty Listener starting on port " + this.nettyConfig.getPort());
            } else {
                log.error("Netty Listener cannot start on port " + this.nettyConfig.getPort());
            }
        }
        catch (InterruptedException e) {
            log.error("Netty Listener cannot start on port " + this.nettyConfig.getPort(), e);
        }
    }

    private void addChannelInitializer() {
        CarbonNettyServerInitializer handler = new CarbonNettyServerInitializer(this.nettyConfig);
        handler.setSslConfig(this.nettyConfig.getSslConfig());
        handler.setSslConfigMap(this.sslConfigMap);
        List<Parameter> parameters = this.nettyConfig.getParameters();
        Map<String, String> paramMap = new HashMap<String, String>();
        if (parameters != null && !parameters.isEmpty()) {
            paramMap = parameters.stream().collect(Collectors.toMap(Parameter::getName, Parameter::getValue));
        }
        handler.setup(paramMap);
        this.bootstrap.childHandler(handler);
    }

    @Override
    public void stop() {
        log.info("Stopping Netty transport " + this.id + " on port " + this.nettyConfig.getPort());
        this.shutdownEventLoops();
    }

    @Override
    public void beginMaintenance() {
        log.info("Putting Netty transport " + this.id + " on port " + this.nettyConfig.getPort() + " into maintenance mode");
        this.shutdownEventLoops();
    }

    @Override
    public void endMaintenance() {
        log.info("Ending maintenance mode for Netty transport " + this.id + " running on port " + this.nettyConfig.getPort());
        this.bossGroup = new NioEventLoopGroup(this.nettyConfig.getBossThreadPoolSize());
        this.workerGroup = new NioEventLoopGroup(this.nettyConfig.getWorkerThreadPoolSize());
        this.startTransport();
    }

    private void shutdownEventLoops() {
        Future<?> f = this.bossGroup.shutdownGracefully();
        f.addListener(new GenericFutureListener<Future<Object>>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                Future<?> f = NettyListener.this.workerGroup.shutdownGracefully();
                f.addListener(new GenericFutureListener<Future<Object>>(){

                    @Override
                    public void operationComplete(Future<Object> future) throws Exception {
                        log.info("Netty transport " + NettyListener.this.id + " on port " + NettyListener.this.nettyConfig.getPort() + " stopped successfully");
                    }
                });
            }
        });
    }

    @Override
    public void setMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
    }

    @Override
    public boolean listen(String host, int port) {
        try {
            ChannelFuture future = this.bootstrap.bind(new InetSocketAddress(host, port)).sync();
            if (future.isSuccess()) {
                this.channelFutureMap.put(port, future);
                log.info("Netty Listener starting on host  " + host + " and port " + port);
                return true;
            }
            log.error("Cannot bind port for host " + host + " port " + port);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), e);
        }
        return false;
    }

    @Override
    public boolean listen(String host, int port, Map<String, String> map) {
        String id = host + ":" + port;
        if (map != null) {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            String certPass = map.get("certPass");
            String keyStorePass = map.get("keyStorePass");
            String keyStoreFile = map.get("keyStoreFile");
            String trustoreFile = map.get("trustStoreFile");
            String trustorePass = map.get("trustStorePass");
            map.forEach((key, value) -> {
                Parameter parm = new Parameter();
                parm.setName((String)key);
                parm.setValue((String)value);
                parameters.add(parm);
            });
            SSLConfig sslConfig = Util.getSSLConfigForListener(certPass, keyStorePass, keyStoreFile, trustoreFile, trustorePass, parameters);
            this.sslConfigMap.put(id, sslConfig);
            this.listen(host, port);
        }
        return false;
    }

    @Override
    public boolean stopListening(String host, int port) {
        String id = host + ":" + port;
        ChannelFuture future = this.channelFutureMap.remove(port);
        if (future != null) {
            if (this.sslConfigMap.get(id) != null) {
                this.sslConfigMap.remove(id);
            }
            future.channel().close();
            log.info("Netty Listener stopped  listening on  host  " + host + " and port " + port);
            return true;
        }
        return false;
    }
}

