/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import java.util.List;
import org.wso2.carbon.transport.http.netty.config.Parameter;

public class ServerBootstrapConfiguration {
    private static ServerBootstrapConfiguration bootstrapConfig;
    private boolean tcpNoDelay = true;
    private int connectTimeOut = 15000;
    private int reciveBufferSize = 0x100000;
    private int sendBufferSize = 0x100000;
    private boolean keepAlive = true;
    private boolean socketReuse = false;
    private int soBackLog = 100;
    private int socketTimeOut = 15;

    private ServerBootstrapConfiguration(List<Parameter> parameters) {
        if (parameters != null) {
            parameters.forEach(parameter -> {
                if ("server.bootstrap.connect.timeout".equals(parameter.getName())) {
                    this.connectTimeOut = Integer.parseInt(parameter.getValue());
                } else if ("server.bootstrap.keepalive".equals(parameter.getName())) {
                    this.keepAlive = Boolean.parseBoolean(parameter.getValue());
                } else if ("server.bootstrap.recievebuffersize".equals(parameter.getName())) {
                    this.reciveBufferSize = Integer.parseInt(parameter.getValue());
                } else if ("server.bootstrap.sendbuffersize".equals(parameter.getName())) {
                    this.sendBufferSize = Integer.parseInt(parameter.getValue());
                } else if ("server.bootstrap.nodelay".equals(parameter.getName())) {
                    this.tcpNoDelay = Boolean.parseBoolean(parameter.getValue());
                } else if ("server.bootstrap.socket.reuse".equals(parameter.getName())) {
                    this.socketReuse = Boolean.parseBoolean(parameter.getValue());
                } else if ("server.bootstrap.socket.backlog".equals(parameter.getName())) {
                    this.soBackLog = Integer.parseInt(parameter.getValue());
                } else if ("server.bootstrap.socket.timeout".equals(parameter.getName())) {
                    this.socketTimeOut = Integer.parseInt(parameter.getValue());
                }
            });
        }
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public int getReciveBufferSize() {
        return this.reciveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public int getSoBackLog() {
        return this.soBackLog;
    }

    public static ServerBootstrapConfiguration getInstance() {
        return bootstrapConfig;
    }

    public int getSoTimeOut() {
        return this.socketTimeOut;
    }

    public static void createBootStrapConfiguration(List<Parameter> parameters) {
        bootstrapConfig = new ServerBootstrapConfiguration(parameters);
    }
}

