/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender;

import com.lmax.disruptor.RingBuffer;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.MessageProcessorException;
import org.wso2.carbon.messaging.TransportSender;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.common.disruptor.config.DisruptorConfig;
import org.wso2.carbon.transport.http.netty.common.disruptor.config.DisruptorFactory;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.config.Parameter;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.BootstrapConfiguration;
import org.wso2.carbon.transport.http.netty.sender.channel.ChannelUtils;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class NettySender
implements TransportSender {
    private static final Logger log = LoggerFactory.getLogger(NettySender.class);
    private String id;
    private ConnectionManager connectionManager;
    private SenderConfiguration senderConfiguration;

    public NettySender(SenderConfiguration senderConfiguration) {
        this.id = senderConfiguration.getId();
        this.senderConfiguration = senderConfiguration;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (senderConfiguration.getParameters() != null && !senderConfiguration.getParameters().isEmpty()) {
            for (Parameter parameter : senderConfiguration.getParameters()) {
                paramMap.put(parameter.getName(), parameter.getValue());
            }
        }
        DisruptorConfig disruptorConfig = new DisruptorConfig((String)paramMap.get("disruptor.buffer.size"), (String)paramMap.get("disruptor.count"), (String)paramMap.get("disruptor.eventhandler.count"), (String)paramMap.get("disruptor.wait.strategy"), Boolean.parseBoolean("share.disruptor.with.outbound"), (String)paramMap.get("disruptor.consumer.worker.pool.size"));
        DisruptorFactory.createDisruptors(DisruptorFactory.DisruptorType.OUTBOUND, disruptorConfig);
        BootstrapConfiguration.createBootStrapConfiguration(paramMap);
        this.connectionManager = ConnectionManager.getInstance(paramMap);
    }

    @Override
    public boolean send(CarbonMessage msg, CarbonCallback callback) throws MessageProcessorException {
        HttpRequest httpRequest = Util.createHttpRequest(msg);
        if (msg.getProperty("HOST") == null) {
            log.debug("Cannot find property HOST hence using default as localhost Please specify remote host as 'HOST' in carbon message property ");
            msg.setProperty("HOST", "localhost");
        }
        if (msg.getProperty("PORT") == null) {
            SSLConfig sslConfig = this.senderConfiguration.getSslConfig();
            int port = 80;
            if (sslConfig != null) {
                port = 443;
            }
            log.debug("Cannot find property PORT hence using default as " + port + " Please specify remote host as 'PORT' in carbon message property ");
            msg.setProperty("PORT", port);
        }
        HttpRoute route = new HttpRoute((String)msg.getProperty("HOST"), (Integer)msg.getProperty("PORT"));
        SourceHandler srcHandler = (SourceHandler)msg.getProperty("SRC_HNDLR");
        if (srcHandler == null) {
            log.debug("Cannot find property SRC_HNDLR hence Sender uses as standalone.If you need to use sender withlistener side please copy property SRC_HNDLR from incoming message");
        }
        RingBuffer ringBuffer = (RingBuffer)msg.getProperty("DISRUPTOR");
        Boolean enableDisruptor = false;
        if (msg.getProperty("enable.disruptor") != null) {
            enableDisruptor = (Boolean)msg.getProperty("enable.disruptor");
        } else {
            log.debug("Cannot find property 'enable.disruptor   hence using worker pool as thread model for client side if you neeed to sender side compatible with Listener side please copy valuesSRC_HANDLER property , enable.disruptor properties from ");
        }
        if (ringBuffer == null && enableDisruptor.booleanValue()) {
            DisruptorConfig disruptorConfig = DisruptorFactory.getDisruptorConfig(DisruptorFactory.DisruptorType.OUTBOUND);
            ringBuffer = disruptorConfig.getDisruptor();
        } else if (!enableDisruptor.booleanValue()) {
            this.senderConfiguration.setDisruptorOn(false);
        }
        Channel outboundChannel = null;
        try {
            TargetChannel targetChannel = this.connectionManager.getTargetChannel(route, srcHandler, this.senderConfiguration, httpRequest, msg, callback, ringBuffer);
            if (targetChannel != null) {
                outboundChannel = targetChannel.getChannel();
                targetChannel.getTargetHandler().setCallback(callback);
                targetChannel.getTargetHandler().setIncomingMsg(msg);
                targetChannel.getTargetHandler().setRingBuffer(ringBuffer);
                targetChannel.getTargetHandler().setTargetChannel(targetChannel);
                targetChannel.getTargetHandler().setConnectionManager(this.connectionManager);
                boolean written = ChannelUtils.writeContent(outboundChannel, httpRequest, msg);
                if (written) {
                    targetChannel.setRequestWritten(true);
                }
            }
        }
        catch (Exception failedCause) {
            throw new MessageProcessorException(failedCause.getMessage(), failedCause);
        }
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

