/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.concurrent.ExecutorService;
import org.wso2.carbon.messaging.FaultHandler;
import org.wso2.carbon.messaging.exceptions.EndPointTimeOut;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportContextHolder;
import org.wso2.carbon.transport.http.netty.message.NettyCarbonMessage;
import org.wso2.carbon.transport.http.netty.sender.TargetHandler;

public class WorkerPoolDispatchingTargetHandler
extends TargetHandler {
    public WorkerPoolDispatchingTargetHandler(int timeoutSeconds) {
        super(timeoutSeconds);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            ExecutorService executorService;
            this.cMsg = this.setUpCarbonMessage(ctx, msg);
            if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetResponseReceiving(this.cMsg);
            }
            if ((executorService = (ExecutorService)this.incomingMsg.getProperty("executor.workerpool")) != null) {
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        WorkerPoolDispatchingTargetHandler.this.callback.done(WorkerPoolDispatchingTargetHandler.this.cMsg);
                    }
                });
            } else {
                LOG.error("Executor service is not registered to request may be listener configuration is wrong or incomingrequest properties are modified incorrectly");
            }
        } else if (this.cMsg != null) {
            if (msg instanceof LastHttpContent) {
                LastHttpContent httpContent = (LastHttpContent)msg;
                ((NettyCarbonMessage)this.cMsg).addHttpContent(httpContent);
                this.cMsg.setEndOfMsgAdded(true);
                if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetResponseSending(this.cMsg);
                }
                this.targetChannel.setRequestWritten(false);
                this.connectionManager.returnChannel(this.targetChannel);
            } else {
                DefaultHttpContent httpContent = (DefaultHttpContent)msg;
                ((NettyCarbonMessage)this.cMsg).addHttpContent(httpContent);
            }
        }
    }

    @Override
    protected void readTimedOut(ChannelHandlerContext ctx) {
        ctx.channel().close();
        if (this.targetChannel.isRequestWritten()) {
            String payload = "<errorMessage>ReadTimeoutException occurred for endpoint " + this.targetChannel.getHttpRoute().toString() + "</errorMessage>";
            FaultHandler faultHandler = null;
            try {
                faultHandler = this.incomingMsg.getFaultHandlerStack().pop();
            }
            catch (Exception e) {
                LOG.debug("Cannot find registered fault handler");
            }
            if (faultHandler != null) {
                faultHandler.handleFault("504", new EndPointTimeOut(payload), this.incomingMsg, this.callback);
                this.incomingMsg.getFaultHandlerStack().push(faultHandler);
            } else {
                this.callback.done(this.createErrorMessage(payload));
            }
        }
    }
}

