/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.beanconversion;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.wso2.msf4j.beanconversion.MediaTypeConverter;
import org.wso2.msf4j.internal.beanconversion.JsonConverter;
import org.wso2.msf4j.internal.beanconversion.TextPlainConverter;
import org.wso2.msf4j.internal.beanconversion.XmlConverter;

public class BeanConverter {
    private static final MediaTypeConverter DEFAULT_CONVERTER = new TextPlainConverter();
    private static final Map<String, MediaTypeConverter> converterMap = new HashMap<String, MediaTypeConverter>();

    private BeanConverter() {
    }

    public static MediaTypeConverter getConverter(String mediaType) {
        MediaTypeConverter mediaTypeConverter = converterMap.get(mediaType.toLowerCase(Locale.US));
        if (mediaTypeConverter == null) {
            mediaTypeConverter = DEFAULT_CONVERTER;
        }
        return mediaTypeConverter;
    }

    private static void addMediaTypeConverter(MediaTypeConverter mediaTypeConverter) {
        for (String mediaType : mediaTypeConverter.getSupportedMediaTypes()) {
            converterMap.put(mediaType.toLowerCase(Locale.US), mediaTypeConverter);
        }
    }

    static {
        BeanConverter.addMediaTypeConverter(new JsonConverter());
        BeanConverter.addMediaTypeConverter(new XmlConverter());
    }
}

