/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import java.util.Set;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;

public class ServerBootstrapConfiguration {
    private static ServerBootstrapConfiguration bootstrapConfig;
    private boolean tcpNoDelay = true;
    private int connectTimeOut = 15000;
    private int reciveBufferSize = 0x100000;
    private int sendBufferSize = 0x100000;
    private boolean keepAlive = true;
    private boolean socketReuse = false;
    private int soBackLog = 100;
    private int socketTimeOut = 15;

    private ServerBootstrapConfiguration(Set<TransportProperty> properties) {
        if (properties != null) {
            properties.forEach(parameter -> {
                if ("server.bootstrap.connect.timeout".equals(parameter.getName())) {
                    this.connectTimeOut = (Integer)parameter.getValue();
                } else if ("server.bootstrap.keepalive".equals(parameter.getName())) {
                    this.keepAlive = (Boolean)parameter.getValue();
                } else if ("server.bootstrap.recievebuffersize".equals(parameter.getName())) {
                    this.reciveBufferSize = (Integer)parameter.getValue();
                } else if ("server.bootstrap.sendbuffersize".equals(parameter.getName())) {
                    this.sendBufferSize = (Integer)parameter.getValue();
                } else if ("server.bootstrap.nodelay".equals(parameter.getName())) {
                    this.tcpNoDelay = (Boolean)parameter.getValue();
                } else if ("server.bootstrap.socket.reuse".equals(parameter.getName())) {
                    this.socketReuse = (Boolean)parameter.getValue();
                } else if ("server.bootstrap.socket.backlog".equals(parameter.getName())) {
                    this.soBackLog = (Integer)parameter.getValue();
                } else if ("server.bootstrap.socket.timeout".equals(parameter.getName())) {
                    this.socketTimeOut = (Integer)parameter.getValue();
                }
            });
        }
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public int getReciveBufferSize() {
        return this.reciveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public int getSoBackLog() {
        return this.soBackLog;
    }

    public static ServerBootstrapConfiguration getInstance() {
        return bootstrapConfig;
    }

    public int getSoTimeOut() {
        return this.socketTimeOut;
    }

    public static void createBootStrapConfiguration(Set<TransportProperty> properties) {
        bootstrapConfig = new ServerBootstrapConfiguration(properties);
    }
}

