/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.engine.config;

import java.util.Optional;
import java.util.Properties;
import org.wso2.carbon.kernel.annotations.Configuration;
import org.wso2.carbon.kernel.annotations.Element;

@Configuration(description="Deployment notifier configuration parameters")
public class DeploymentNotifierConfig {
    @Element(description="JMS publishing enabled")
    private boolean jmsPublishingEnabled = false;
    @Element(description="Desitination JNDI name")
    private String destinationJNDIName = "topic0";
    @Element(description="Destination type")
    private String destinationType = "topic";
    @Element(description="Java naming factory initial")
    private String javaNamingFactoryInitial = "org.wso2.andes.jndi.PropertiesFileInitialContextFactory";
    @Element(description="Java naming provider URL")
    private String javaNamingProviderURL = "conf/jndi.properties";
    @Element(description="JMS user name")
    private Optional<String> jmsUsername = Optional.empty();
    @Element(description="JMS password")
    private Optional<String> jmsPassword = Optional.empty();
    @Element(description="Connection factory JNDI name")
    private String connectionFactoryJNDIName = "TopicConnectionFactory";
    @Element(description="Static massage content")
    private Properties staticMessageContent = new Properties();

    public boolean isJmsPublishingEnabled() {
        return this.jmsPublishingEnabled;
    }

    public String getDestinationJNDIName() {
        return this.destinationJNDIName;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public Optional<String> getJmsUsername() {
        return this.jmsUsername;
    }

    public Optional<String> getJmsPassword() {
        return this.jmsPassword;
    }

    public String getJavaNamingFactoryInitial() {
        return this.javaNamingFactoryInitial;
    }

    public String getJavaNamingProviderURL() {
        return this.javaNamingProviderURL;
    }

    public String getConnectionFactoryJNDIName() {
        return this.connectionFactoryJNDIName;
    }

    public Properties getStaticMessageContent() {
        return Optional.ofNullable(this.staticMessageContent).orElse(new Properties());
    }
}

