/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.configprovider.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.utils.Utils;
import org.yaml.snakeyaml.Yaml;

public class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);

    private ConfigurationUtils() {
    }

    public static Path getConfigurationFileLocation(String filename) {
        return Utils.getCarbonConfigHome().resolve(filename);
    }

    public static String convertXMLToYAML(String xmlString) {
        try {
            JSONObject xmlJSONObj = XML.toJSONObject(xmlString);
            String jsonString = xmlJSONObj.toString();
            Yaml yaml = new Yaml();
            Map map = yaml.loadAs(jsonString, Map.class);
            return yaml.dumpAsMap(map);
        }
        catch (JSONException e) {
            throw new RuntimeException("Exception occurred while converting XML to JSON: ", e);
        }
    }

    public static Map<String, String> getDeploymentConfigMap(String yamlString) {
        HashMap<String, String> deploymentConfigs = new HashMap<String, String>();
        Yaml yaml = new Yaml();
        Map map = yaml.loadAs(yamlString, Map.class);
        map.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> deploymentConfigs.put((String)entry.getKey(), yaml.dumpAsMap(entry.getValue())));
        return deploymentConfigs;
    }

    public static Properties loadProjectProperties() {
        Properties properties = new Properties();
        try (InputStream in = ConfigurationUtils.class.getClassLoader().getResourceAsStream("project.defaults.properties");){
            if (in != null) {
                properties.load(in);
            }
        }
        catch (IOException e) {
            logger.error("Error while reading the project default properties, hence apply default values.", e);
        }
        return properties;
    }
}

