/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal;

import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.utils.CarbonServerInfo;

public class CarbonStartupHandler {
    private static final Logger logger = LoggerFactory.getLogger(CarbonStartupHandler.class);

    private CarbonStartupHandler() {
    }

    public static void logServerStartupTime(String serverName) {
        double startTime = Long.parseLong(System.getProperty("carbon.start.time"));
        double startupTime = ((double)System.currentTimeMillis() - startTime) / 1000.0;
        DecimalFormat decimalFormatter = new DecimalFormat("#,##0.000");
        logger.info(serverName + " started in " + decimalFormatter.format(startupTime) + " sec");
    }

    public static void registerCarbonServerInfoService() {
        DataHolder.getInstance().getBundleContext().registerService(CarbonServerInfo.class, (Object)new CarbonServerInfo(), null);
    }
}

