/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.securevault;

import java.util.Optional;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.securevault.SecureVaultConfigurationProvider;
import org.wso2.carbon.kernel.internal.securevault.SecureVaultDataHolder;
import org.wso2.carbon.kernel.internal.securevault.SecureVaultImpl;
import org.wso2.carbon.kernel.securevault.MasterKeyReader;
import org.wso2.carbon.kernel.securevault.SecretRepository;
import org.wso2.carbon.kernel.securevault.SecureVault;
import org.wso2.carbon.kernel.securevault.config.model.SecureVaultConfiguration;
import org.wso2.carbon.kernel.securevault.exception.SecureVaultException;

@Component(name="org.wso2.carbon.kernel.internal.securevault.SecureVaultComponent", immediate=true)
public class SecureVaultComponent {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultComponent.class);
    private Optional<SecureVaultConfiguration> optSecureVaultConfiguration;
    private boolean initialized = false;
    private String secretRepositoryType;
    private String masterKeyReaderType;

    public SecureVaultComponent() {
        try {
            this.optSecureVaultConfiguration = Optional.of(SecureVaultConfigurationProvider.getConfiguration());
            this.optSecureVaultConfiguration.ifPresent(secureVaultConfiguration -> {
                this.secretRepositoryType = secureVaultConfiguration.getSecretRepositoryConfig().getType().orElse("");
                this.masterKeyReaderType = secureVaultConfiguration.getMasterKeyReaderConfig().getType().orElse("");
            });
        }
        catch (RuntimeException | SecureVaultException e) {
            this.optSecureVaultConfiguration = Optional.empty();
            logger.error("Error while acquiring secure vault configuration", e);
        }
    }

    @Activate
    public void activate() {
        logger.debug("Activating SecureVaultComponent");
    }

    @Deactivate
    public void deactivate() {
        logger.debug("Deactivating SecureVaultComponent");
    }

    @Reference(name="secure.vault.secret.repository", service=SecretRepository.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterSecretRepository")
    protected void registerSecretRepository(SecretRepository secretRepository) {
        if (secretRepository.getClass().getName().equals(this.secretRepositoryType)) {
            logger.debug("Registering secret repository : {}", (Object)this.secretRepositoryType);
            SecureVaultDataHolder.getInstance().setSecretRepository(secretRepository);
            this.initializeSecureVault();
        }
    }

    protected void unRegisterSecretRepository(SecretRepository secretRepository) {
        if (secretRepository.getClass().getName().equals(this.secretRepositoryType)) {
            logger.debug("Un-registering secret repository : {}", (Object)this.secretRepositoryType);
            SecureVaultDataHolder.getInstance().setSecretRepository(null);
        }
    }

    @Reference(name="secure.vault.master.key.reader", service=MasterKeyReader.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterMasterKeyReader")
    protected void registerMasterKeyReader(MasterKeyReader masterKeyReader) {
        if (masterKeyReader.getClass().getName().equals(this.masterKeyReaderType)) {
            logger.debug("Registering secret repository : ", (Object)this.masterKeyReaderType);
            SecureVaultDataHolder.getInstance().setMasterKeyReader(masterKeyReader);
            this.initializeSecureVault();
        }
    }

    protected void unregisterMasterKeyReader(MasterKeyReader masterKeyReader) {
        if (masterKeyReader.getClass().getName().equals(this.masterKeyReaderType)) {
            logger.debug("Un-registering secret repository : ", (Object)this.masterKeyReaderType);
            SecureVaultDataHolder.getInstance().setMasterKeyReader(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSecureVault() {
        SecureVaultComponent secureVaultComponent = this;
        synchronized (secureVaultComponent) {
            if (this.initialized) {
                logger.debug("Secure Vault Component is already initialized");
                return;
            }
            if (!SecureVaultDataHolder.getInstance().getSecretRepository().isPresent() || !SecureVaultDataHolder.getInstance().getMasterKeyReader().isPresent()) {
                logger.debug("Waiting for Secure Vault dependencies");
                return;
            }
            try {
                logger.debug("Initializing the secure vault with, SecretRepositoryType={}, MasterKeyReaderType={}", (Object)this.secretRepositoryType, (Object)this.masterKeyReaderType);
                SecureVaultConfiguration secureVaultConfiguration = this.optSecureVaultConfiguration.orElseThrow(() -> new SecureVaultException("Cannot initialize secure vault without secure vault configurations"));
                MasterKeyReader masterKeyReader = SecureVaultDataHolder.getInstance().getMasterKeyReader().orElseThrow(() -> new SecureVaultException("Cannot initialise secure vault without master key reader"));
                SecretRepository secretRepository = SecureVaultDataHolder.getInstance().getSecretRepository().orElseThrow(() -> new SecureVaultException("Cannot initialise secure vault without secret repository"));
                masterKeyReader.init(secureVaultConfiguration.getMasterKeyReaderConfig());
                secretRepository.init(secureVaultConfiguration.getSecretRepositoryConfig(), masterKeyReader);
                secretRepository.loadSecrets(secureVaultConfiguration.getSecretRepositoryConfig());
                Optional.ofNullable(DataHolder.getInstance().getBundleContext()).ifPresent(bundleContext -> bundleContext.registerService(SecureVault.class, (Object)new SecureVaultImpl(), null));
                this.initialized = true;
            }
            catch (SecureVaultException e) {
                logger.error("Failed to initialize Secure Vault.", e);
            }
        }
        logger.debug("Secure Vault initialized successfully");
    }
}

