/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.utils.MBeanManagementFactory;

public class MBeanRegistrator {
    private static final Logger logger = LoggerFactory.getLogger(MBeanRegistrator.class);
    private static List<ObjectName> mBeans = new ArrayList<ObjectName>();

    private MBeanRegistrator() {
    }

    public static void registerMBean(Object mBeanInstance) throws RuntimeException {
        block7: {
            String className = mBeanInstance.getClass().getName();
            if (className.indexOf(46) != -1) {
                className = className.substring(className.lastIndexOf(46) + 1);
            }
            String objectName = "org.wso2.carbon:type=" + className;
            try {
                MBeanServer mBeanServer = MBeanManagementFactory.getMBeanServer();
                Set<ObjectName> set = mBeanServer.queryNames(new ObjectName(objectName), null);
                if (set.isEmpty()) {
                    try {
                        ObjectName name = new ObjectName(objectName);
                        mBeanServer.registerMBean(mBeanInstance, name);
                        mBeans.add(name);
                        break block7;
                    }
                    catch (InstanceAlreadyExistsException e) {
                        String msg = "MBean " + objectName + " already exists";
                        logger.error(msg, e);
                        throw new RuntimeException(msg, e);
                    }
                    catch (MBeanRegistrationException | NotCompliantMBeanException e) {
                        String msg = "Execption when registering MBean";
                        logger.error(msg, e);
                        throw new RuntimeException(msg, e);
                    }
                }
                String msg = "MBean " + objectName + " already exists";
                logger.error(msg);
                throw new RuntimeException(msg);
            }
            catch (MalformedObjectNameException e) {
                String msg = "Could not register " + mBeanInstance.getClass() + " MBean";
                logger.error(msg);
                throw new RuntimeException(msg, e);
            }
        }
    }

    public static void unregisterAllMBeans() {
        MBeanServer mBeanServer = MBeanManagementFactory.getMBeanServer();
        mBeans.forEach(mBean -> {
            try {
                mBeanServer.unregisterMBean((ObjectName)mBean);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e) {
                logger.error("Cannot unregister MBean " + mBean.getCanonicalName(), e);
            }
        });
    }
}

