/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.securevault;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.securevault.MasterKey;
import org.wso2.carbon.kernel.securevault.config.model.SecretRepositoryConfiguration;
import org.wso2.carbon.kernel.securevault.exception.SecureVaultException;
import org.wso2.carbon.kernel.utils.Utils;

public class SecureVaultUtils {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultUtils.class);
    private static final String defaultCharset = StandardCharsets.UTF_8.name();
    private static final Pattern varPatternEnv = Pattern.compile("\\$\\{env:([^}]*)}");
    private static final Pattern varPatternSys = Pattern.compile("\\$\\{sys:([^}]*)}");

    public static MasterKey getSecret(List<MasterKey> masterKeys, String secretName) throws SecureVaultException {
        return masterKeys.stream().filter(masterKey -> masterKey.getMasterKeyName().equals(secretName)).findFirst().orElseThrow(() -> new SecureVaultException("No secret found with given secret name '" + secretName + "'"));
    }

    public static byte[] base64Decode(byte[] base64Encoded) {
        return Base64.getDecoder().decode(base64Encoded);
    }

    public static byte[] base64Encode(byte[] original) {
        return Base64.getEncoder().encode(original);
    }

    public static char[] toChars(byte[] bytes) {
        Charset charset = Charset.forName(defaultCharset);
        return charset.decode(ByteBuffer.wrap(bytes)).array();
    }

    public static byte[] toBytes(String value) {
        return value.getBytes(Charset.forName(defaultCharset));
    }

    public static Properties loadSecretFile(Path secretsFilePath) throws SecureVaultException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(secretsFilePath.toFile());
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, defaultCharset));){
            properties.load(bufferedReader);
        }
        catch (FileNotFoundException e) {
            throw new SecureVaultException("Cannot find secrets file in given location. (location: " + secretsFilePath + ")", e);
        }
        catch (IOException e) {
            throw new SecureVaultException("Cannot access secrets file in given location. (location: " + secretsFilePath + ")", e);
        }
        return properties;
    }

    public static void updateSecretFile(Path secretsFilePath, Properties properties) throws SecureVaultException {
        try (FileOutputStream outputStream = new FileOutputStream(secretsFilePath.toFile());
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, defaultCharset);){
            properties.store(outputStreamWriter, null);
        }
        catch (FileNotFoundException e) {
            throw new SecureVaultException("Cannot find secrets file in given location. (location: " + secretsFilePath + ")", e);
        }
        catch (IOException e) {
            throw new SecureVaultException("Cannot access secrets file in given location. (location: " + secretsFilePath + ")", e);
        }
    }

    public static String getSecretPropertiesFileLocation(SecretRepositoryConfiguration secretRepositoryConfiguration) {
        return secretRepositoryConfiguration.getParameter("location").orElseGet(() -> Utils.getCarbonConfigHome().resolve(Paths.get("security", "secrets.properties")).toString());
    }

    public static String getSecureVaultYAMLLocation() {
        return Utils.getCarbonConfigHome().resolve("secure-vault.yaml").toString();
    }

    private SecureVaultUtils() {
        throw new AssertionError((Object)"Trying to a instantiate a constant class");
    }

    public static String readUpdatedValue(String alias) {
        if (alias != null) {
            if (alias.startsWith("${env:")) {
                return SecureVaultUtils.readFromEnvironment(alias.substring(6, alias.length() - 1));
            }
            if (alias.startsWith("${sys:")) {
                return SecureVaultUtils.readFromSystem(alias.substring(6, alias.length() - 1));
            }
        }
        return alias;
    }

    private static String readFromEnvironment(String alias) {
        return Optional.ofNullable(alias).map(System::getenv).orElse(alias);
    }

    private static String readFromSystem(String alias) {
        return Optional.ofNullable(alias).map(System::getProperty).orElse(alias);
    }

    public static String substituteVariables(String value) throws SecureVaultException {
        if (varPatternEnv.matcher(value).find()) {
            value = SecureVaultUtils.substituteVariables(varPatternEnv.matcher(value), System::getenv);
        }
        if (varPatternSys.matcher(value).find()) {
            value = SecureVaultUtils.substituteVariables(varPatternSys.matcher(value), System::getProperty);
        }
        return value;
    }

    public static String substituteVariables(Matcher matcher, Function<String, String> function) throws SecureVaultException {
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String sysPropKey = matcher.group(1);
            String sysPropValue = function.apply(sysPropKey);
            if (sysPropValue == null || sysPropValue.length() == 0) {
                String msg = "A value for placeholder '" + sysPropKey + "' is not specified";
                logger.error(msg);
                throw new SecureVaultException(msg);
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            matcher.appendReplacement(sb, sysPropValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    public static String resolveFileToString(File file) throws SecureVaultException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

