/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.deployer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.deployment.engine.Artifact;
import org.wso2.carbon.deployment.engine.ArtifactType;
import org.wso2.carbon.deployment.engine.Deployer;
import org.wso2.carbon.deployment.engine.exception.CarbonDeploymentException;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.internal.MicroservicesServerSC;
import org.wso2.msf4j.internal.deployer.MicroserviceDeploymentException;
import org.wso2.msf4j.internal.deployer.MicroserviceDeploymentUtils;

@Component(name="org.wso2.carbon.mss.internal.deployer.MicroservicesDeployer", service={Deployer.class}, immediate=true)
public class MicroservicesDeployer
implements Deployer,
RequiredCapabilityListener {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesDeployer.class);
    private static final String DEPLOYMENT_PATH = "file:microservices";
    private static final String[] SUPPORTED_EXTENSIONS = new String[]{"jar", "zip"};
    private static final String MICROSERVICE_ARTIFACT_TYPE = "microservices";
    private URL deploymentLocation;
    private ArtifactType artifactType;
    private Map<Object, List<Object>> deployedArtifacts = new HashMap<Object, List<Object>>();

    @Override
    public void init() {
        if (log.isDebugEnabled()) {
            log.debug("microservice deployer initializing");
        }
        this.artifactType = new ArtifactType<String>(MICROSERVICE_ARTIFACT_TYPE);
        try {
            this.deploymentLocation = new URL(DEPLOYMENT_PATH);
        }
        catch (MalformedURLException e) {
            log.error("microservices deployer location error | location: file:microservices", e);
        }
    }

    @Override
    public Object deploy(Artifact artifact) throws CarbonDeploymentException {
        if (artifact == null || artifact.getFile() == null) {
            throw new CarbonDeploymentException("Deployment artifact cannot be null");
        }
        File artifactFile = artifact.getFile();
        String artifactPath = artifactFile.getAbsolutePath();
        if (this.isSupportedFile(artifactFile)) {
            List<Object> resourcesList;
            log.info("Deploying microservice artifact: {}", (Object)artifactPath);
            try {
                resourcesList = MicroserviceDeploymentUtils.getRourceInstances(artifactFile);
            }
            catch (MicroserviceDeploymentException e) {
                throw new CarbonDeploymentException("Error while processing the artifact: " + artifactPath, e);
            }
            if (resourcesList.size() == 0) {
                throw new CarbonDeploymentException("No classes to initialize in artifact: " + artifactPath);
            }
            boolean deployed = resourcesList.stream().filter(resource -> resource instanceof Microservice).map(resource -> this.addService((Microservice)resource)).anyMatch(result -> result == Boolean.FALSE);
            if (!deployed) {
                artifact.setKey(artifactPath);
                this.deployedArtifacts.put(artifactPath, resourcesList);
                return artifactPath;
            }
        }
        return null;
    }

    @Override
    public void undeploy(Object key) throws CarbonDeploymentException {
        log.info("Undeploying artifact: {}", key);
        List<Object> resourcesList = this.deployedArtifacts.get(key);
        if (resourcesList != null) {
            resourcesList.forEach(resource -> {
                if (resource instanceof Microservice) {
                    this.removeService((Microservice)resource);
                }
            });
        }
    }

    @Override
    public Object update(Artifact artifact) throws CarbonDeploymentException {
        File artifactFile = artifact.getFile();
        String artifactPath = artifactFile.getAbsolutePath();
        if (this.isSupportedFile(artifactFile)) {
            log.info("Updating artifact: {}", (Object)artifactPath);
            this.undeploy(artifact.getKey());
            this.deploy(artifact);
        }
        return artifactPath;
    }

    @Override
    public URL getLocation() {
        return this.deploymentLocation;
    }

    @Override
    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    @Activate
    protected void start(BundleContext bundleContext) {
    }

    @Deactivate
    protected void stop() {
    }

    private boolean isSupportedFile(File file) {
        return Arrays.stream(SUPPORTED_EXTENSIONS).filter(s -> s.equalsIgnoreCase(this.getFileExtension(file))).findAny().isPresent();
    }

    private String getFileExtension(File file) {
        int i;
        String extension = "";
        if (file == null) {
            return extension;
        }
        String fileName = file.getName();
        if (file.isFile() && (i = fileName.lastIndexOf(46)) > 0) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    private boolean addService(Microservice service) {
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (microservicesRegistries.isEmpty()) {
            log.error("Microservice deployment failed. Microservices Registry doesn't exist to register microservice.");
            return false;
        }
        microservicesRegistries.values().forEach(registry -> registry.addService(service));
        log.info("Microservice {} deployed successfully", (Object)service.getClass().getName());
        return true;
    }

    private boolean removeService(Microservice service) {
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (microservicesRegistries.isEmpty()) {
            log.error("Microservice removal failed. Microservices Registry doesn't exist to register microservice.");
            return false;
        }
        microservicesRegistries.values().forEach(registry -> {
            registry.removeService(service.getClass().getAnnotation(Path.class).value());
            registry.preDestroyService(service);
        });
        log.info("Microservice {} undeployed successfully", (Object)service.getClass().getName());
        return true;
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        DataHolder.getInstance().getBundleContext().registerService(MicroservicesDeployer.class, (Object)this, null);
        log.debug("MicroservicesDeployer service is available");
    }

    @Reference(name="microservices-server", service=MicroservicesServerSC.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="removeMicroservicesServer")
    protected void addMicroservicesServer(MicroservicesServerSC microservicesServerSC) {
        if (log.isDebugEnabled()) {
            log.debug("Microservices server binded successfully.");
        }
    }

    protected void removeMicroservicesServer(MicroservicesServerSC microservicesServerSC) {
        if (log.isDebugEnabled()) {
            log.debug("Microservices server unbinded successfully.");
        }
    }
}

