/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.common.ssl;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;

public class SSLHandlerFactory {
    private String protocol = null;
    private final SSLContext serverContext;
    private SSLConfig sslConfig;
    private boolean needClientAuth;
    private KeyManagerFactory kmf;
    private TrustManagerFactory tmf;

    public SSLHandlerFactory(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        this.needClientAuth = sslConfig.isNeedClientAuth();
        this.protocol = sslConfig.getSslProtocol();
        try {
            KeyStore ks = this.getKeyStore(sslConfig.getKeyStore(), sslConfig.getKeyStorePass());
            this.kmf = KeyManagerFactory.getInstance(algorithm);
            KeyManager[] keyManagers = null;
            if (ks != null) {
                this.kmf.init(ks, sslConfig.getCertPass() != null ? sslConfig.getCertPass().toCharArray() : sslConfig.getKeyStorePass().toCharArray());
                keyManagers = this.kmf.getKeyManagers();
            }
            TrustManager[] trustManagers = null;
            if (sslConfig.getTrustStore() != null) {
                KeyStore tks = this.getKeyStore(sslConfig.getTrustStore(), sslConfig.getTrustStorePass());
                this.tmf = TrustManagerFactory.getInstance(algorithm);
                this.tmf.init(tks);
                trustManagers = this.tmf.getTrustManagers();
            }
            this.serverContext = SSLContext.getInstance(this.protocol);
            this.serverContext.init(keyManagers, trustManagers, null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Failed to initialize the server-side SSLContext", e);
        }
    }

    private KeyStore getKeyStore(File keyStore, String keyStorePassword) throws IOException {
        KeyStore ks = null;
        String tlsStoreType = this.sslConfig.getTlsStoreType();
        if (keyStore != null && keyStorePassword != null) {
            try (FileInputStream is = new FileInputStream(keyStore);){
                ks = KeyStore.getInstance(tlsStoreType);
                ks.load(is, keyStorePassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return ks;
    }

    public SSLEngine build() {
        SSLEngine engine = this.serverContext.createSSLEngine();
        engine.setNeedClientAuth(this.needClientAuth);
        engine.setUseClientMode(this.sslConfig.isClientMode());
        if (this.sslConfig.getCipherSuites() != null && this.sslConfig.getCipherSuites().length > 0) {
            engine.setEnabledCipherSuites(this.sslConfig.getCipherSuites());
        }
        if (this.sslConfig.getEnableProtocols() != null && this.sslConfig.getEnableProtocols().length > 0) {
            engine.setEnabledProtocols(this.sslConfig.getEnableProtocols());
        }
        if (this.sslConfig.isEnableSessionCreation()) {
            engine.setEnableSessionCreation(true);
        }
        return engine;
    }

    public SslContext createHttp2TLSContext() throws SSLException {
        List<String> ciphers = this.sslConfig.getCipherSuites() != null && this.sslConfig.getCipherSuites().length > 0 ? Arrays.asList(this.sslConfig.getCipherSuites()) : Http2SecurityUtil.CIPHERS;
        SslProvider provider = OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
        return SslContextBuilder.forServer(this.getKeyManagerFactory()).trustManager(this.getTrustStoreFactory()).sslProvider(provider).ciphers(ciphers, SupportedCipherSuiteFilter.INSTANCE).clientAuth(this.needClientAuth ? ClientAuth.REQUIRE : ClientAuth.NONE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, "h2", "http/1.1")).build();
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.kmf;
    }

    public TrustManagerFactory getTrustStoreFactory() {
        return this.tmf;
    }

    public void setSNIServerNames(SSLEngine sslEngine, String peerHost) {
        SSLParameters sslParameters = new SSLParameters();
        ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>();
        serverNames.add(new SNIHostName(peerHost));
        sslParameters.setServerNames(serverNames);
        sslEngine.setSSLParameters(sslParameters);
    }
}

