/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.channel.pool;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;

public class PoolConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PoolConfiguration.class);
    private static PoolConfiguration poolConfiguration;
    private int maxActivePerPool = -1;
    private int minIdlePerPool;
    private int maxIdlePerPool = 100;
    private boolean testOnBorrow = true;
    private boolean testWhileIdle = true;
    private long timeBetweenEvictionRuns = 30000L;
    private long minEvictableIdleTime = 300000L;
    private byte exhaustedAction = 1;
    private int numberOfPools = 0;
    private int executorServiceThreads = 20;
    private int eventGroupExecutorThreads = 15;
    private long setMaxWait = 60000L;

    private PoolConfiguration(Map<String, Object> transportProperties) {
        this.numberOfPools = Util.getIntProperty(transportProperties, "client.connection.pool.count", 0);
        this.maxActivePerPool = Util.getIntProperty(transportProperties, "client.max.active.connections.per.pool", -1);
        this.minIdlePerPool = Util.getIntProperty(transportProperties, "client.min.idle.connections.per.pool", 0);
        this.maxIdlePerPool = Util.getIntProperty(transportProperties, "cleint.max.idle.connections.per.pool", 100);
        this.minEvictableIdleTime = Util.getIntProperty(transportProperties, "client.min.eviction.idle.time", 300000);
        this.executorServiceThreads = Util.getIntProperty(transportProperties, "sender.thread.count", 20);
        this.eventGroupExecutorThreads = Util.getIntProperty(transportProperties, "event.group.executor.thread.size", 15);
        this.eventGroupExecutorThreads = Util.getIntProperty(transportProperties, "max.wait.for.client.connection.pool", 60000);
        logger.debug("client.connection.pool.count: " + this.numberOfPools);
        logger.debug("client.max.active.connections.per.pool:" + this.maxActivePerPool);
        logger.debug("client.min.idle.connections.per.pool:" + this.maxIdlePerPool);
        logger.debug("cleint.max.idle.connections.per.pool:" + this.maxIdlePerPool);
        logger.debug("client.min.eviction.idle.time:" + this.minEvictableIdleTime);
        logger.debug("sender.thread.count:" + this.executorServiceThreads);
        logger.debug("Time between Evictions Runs:" + this.timeBetweenEvictionRuns);
        logger.debug("Pool exhausted action:" + this.exhaustedAction);
        logger.debug("Event group executor threads : " + this.eventGroupExecutorThreads);
    }

    public static PoolConfiguration getInstance() {
        return poolConfiguration;
    }

    public static void createPoolConfiguration(Map<String, Object> transportProperties) {
        poolConfiguration = new PoolConfiguration(transportProperties);
    }

    public int getMaxActivePerPool() {
        return this.maxActivePerPool;
    }

    public int getMinIdlePerPool() {
        return this.minIdlePerPool;
    }

    public int getMaxIdlePerPool() {
        return this.maxIdlePerPool;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public long getTimeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    public long getMinEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    public byte getExhaustedAction() {
        return this.exhaustedAction;
    }

    public int getNumberOfPools() {
        return this.numberOfPools;
    }

    public int getExecutorServiceThreads() {
        return this.executorServiceThreads;
    }

    public int getEventGroupExecutorThreads() {
        return this.eventGroupExecutorThreads;
    }

    public long getMaxWait() {
        return this.setMaxWait;
    }
}

