/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.msf4j.SessionManager;

public class Session
implements Serializable {
    private static final long serialVersionUID = -3945729418329160933L;
    private transient SessionManager sessionManager;
    private String id;
    private long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;
    private boolean isValid = true;
    private boolean isNew = true;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public Session() {
    }

    public Session(String id, int maxInactiveInterval) {
        this.id = id;
        this.maxInactiveInterval = maxInactiveInterval;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
    }

    long getCreationTime() {
        return this.creationTime;
    }

    String getId() {
        return this.id;
    }

    void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public Object getAttribute(String name) {
        this.checkValidity();
        return this.attributes.get(name);
    }

    public Set<String> getAttributeNames() {
        this.checkValidity();
        return this.attributes.keySet();
    }

    public void setAttribute(String name, Object value) {
        this.checkValidity();
        this.attributes.put(name, value);
        this.sessionManager.updateSession(this);
    }

    public void removeAttribute(String name) {
        this.checkValidity();
        this.sessionManager.updateSession(this);
        this.attributes.remove(name);
    }

    private void checkValidity() {
        if (!this.isValid) {
            throw new IllegalStateException("Session is invalid");
        }
    }

    public void invalidate() {
        this.sessionManager.invalidateSession(this);
        this.attributes.clear();
        this.isValid = false;
    }

    boolean isValid() {
        return this.isValid;
    }

    boolean isNew() {
        return this.isNew;
    }

    boolean getIsNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    Session setAccessed() {
        this.checkValidity();
        this.lastAccessedTime = System.currentTimeMillis();
        return this;
    }

    long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }
}

