/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.config.RequestSizeValidationConfiguration;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.HttpWsServerConnectorFuture;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.listener.HTTPServerChannelInitializer;
import org.wso2.transport.http.netty.listener.ServerBootstrapConfiguration;

public class ServerConnectorBootstrap {
    private static final Logger log = LoggerFactory.getLogger(ServerConnectorBootstrap.class);
    private ServerBootstrap serverBootstrap = new ServerBootstrap();
    private HTTPServerChannelInitializer httpServerChannelInitializer = new HTTPServerChannelInitializer();
    private boolean initialized = false;
    private boolean isHttps = false;

    public ServerConnectorBootstrap() {
        this.serverBootstrap.childHandler(this.httpServerChannelInitializer);
        HTTPTransportContextHolder.getInstance().setHandlerExecutor(new HandlerExecutor());
        this.initialized = true;
    }

    private ChannelFuture bindInterface(HTTPServerConnector serverConnector) {
        if (!this.initialized) {
            log.error("ServerConnectorBootstrap is not initialized");
            return null;
        }
        ChannelFuture future = this.serverBootstrap.bind(new InetSocketAddress(serverConnector.getHost(), serverConnector.getPort()));
        return future;
    }

    public boolean unBindInterface(HTTPServerConnector serverConnector) throws InterruptedException {
        if (!this.initialized) {
            log.error("ServerConnectorBootstrap is not initialized");
            return false;
        }
        ChannelFuture future = serverConnector.getChannelFuture();
        if (future != null) {
            ChannelFuture channelFuture = future.channel().close();
            channelFuture.sync();
            log.info("HttpConnectorListener stopped listening on host " + serverConnector.getHost() + " and port " + serverConnector.getPort());
            return true;
        }
        return false;
    }

    public ServerConnector getServerConnector(String host, int port) {
        String serverConnectorId = Util.createServerConnectorID(host, port);
        return new HTTPServerConnector(serverConnectorId, this, host, port);
    }

    public void addSocketConfiguration(ServerBootstrapConfiguration serverBootstrapConfiguration) {
        this.serverBootstrap.option(ChannelOption.SO_BACKLOG, serverBootstrapConfiguration.getSoBackLog());
        this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, serverBootstrapConfiguration.isTcpNoDelay());
        this.serverBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, serverBootstrapConfiguration.getConnectTimeOut());
        this.serverBootstrap.option(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReceiveBufferSize());
        this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReceiveBufferSize());
        this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, serverBootstrapConfiguration.getSendBufferSize());
        log.debug("Netty Server Socket BACKLOG " + serverBootstrapConfiguration.getSoBackLog());
        log.debug("Netty Server Socket TCP_NODELAY " + serverBootstrapConfiguration.isTcpNoDelay());
        log.debug("Netty Server Socket CONNECT_TIMEOUT_MILLIS " + serverBootstrapConfiguration.getConnectTimeOut());
        log.debug("Netty Server Socket SO_RCVBUF " + serverBootstrapConfiguration.getReceiveBufferSize());
        log.debug("Netty Server Socket SO_RCVBUF " + serverBootstrapConfiguration.getReceiveBufferSize());
        log.debug("Netty Server Socket SO_SNDBUF " + serverBootstrapConfiguration.getSendBufferSize());
    }

    public void addSecurity(SSLConfig sslConfig) {
        if (sslConfig != null) {
            this.httpServerChannelInitializer.setSslConfig(sslConfig);
            this.isHttps = true;
        }
    }

    public void addIdleTimeout(int socketIdleTimeout) {
        this.httpServerChannelInitializer.setIdleTimeout(socketIdleTimeout);
    }

    public void addThreadPools(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this.serverBootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class);
    }

    public void addHttpTraceLogHandler(Boolean isHttpTraceLogEnabled) {
        this.httpServerChannelInitializer.setHttpTraceLogEnabled(isHttpTraceLogEnabled);
    }

    public void addHeaderAndEntitySizeValidation(RequestSizeValidationConfiguration requestSizeValidationConfig) {
        this.httpServerChannelInitializer.setRequestSizeValidationConfig(requestSizeValidationConfig);
    }

    class HTTPServerConnector
    implements ServerConnector {
        private final Logger log = LoggerFactory.getLogger(HTTPServerConnector.class);
        private ChannelFuture channelFuture;
        private ServerConnectorFuture serverConnectorFuture;
        private ServerConnectorBootstrap serverConnectorBootstrap;
        private String host;
        private int port;
        private String connectorID;

        public HTTPServerConnector(String id, ServerConnectorBootstrap serverConnectorBootstrap, String host, int port) {
            this.serverConnectorBootstrap = serverConnectorBootstrap;
            this.host = host;
            this.port = port;
            this.connectorID = id;
            ServerConnectorBootstrap.this.httpServerChannelInitializer.setInterfaceId(Util.createServerConnectorID(host, port));
        }

        @Override
        public ServerConnectorFuture start() {
            this.channelFuture = ServerConnectorBootstrap.this.bindInterface(this);
            this.serverConnectorFuture = new HttpWsServerConnectorFuture(this.channelFuture);
            this.channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    this.log.info("HTTP(S) Interface starting on host " + this.getHost() + " and port " + this.getPort());
                    this.serverConnectorFuture.notifyPortBindingEvent(this.connectorID, ServerConnectorBootstrap.this.isHttps);
                } else {
                    this.serverConnectorFuture.notifyPortBindingError(channelFuture.cause());
                }
            }));
            ServerConnectorBootstrap.this.httpServerChannelInitializer.setServerConnectorFuture(this.serverConnectorFuture);
            return this.serverConnectorFuture;
        }

        @Override
        public boolean stop() {
            boolean connectorStopped = false;
            try {
                connectorStopped = this.serverConnectorBootstrap.unBindInterface(this);
                if (connectorStopped) {
                    this.serverConnectorFuture.notifyPortUnbindingEvent(this.connectorID, ServerConnectorBootstrap.this.isHttps);
                }
            }
            catch (InterruptedException e) {
                this.log.error("Couldn't close the port", e);
                return false;
            }
            catch (ServerConnectorException e) {
                this.log.error("Error in notifying life cycle event listener", e);
            }
            return connectorStopped;
        }

        @Override
        public String getConnectorID() {
            return this.connectorID;
        }

        private ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }

        public String toString() {
            return this.host + "-" + this.port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

