/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketInitMessageImpl;
import org.wso2.transport.http.netty.internal.websocket.WebSocketSessionImpl;
import org.wso2.transport.http.netty.internal.websocket.WebSocketUtil;
import org.wso2.transport.http.netty.listener.WebSocketSourceHandler;

public class WebSocketServerHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerHandshakeHandler.class);
    private final ServerConnectorFuture serverConnectorFuture;
    private final String interfaceId;

    public WebSocketServerHandshakeHandler(ServerConnectorFuture serverConnectorFuture, String interfaceId) {
        this.serverConnectorFuture = serverConnectorFuture;
        this.interfaceId = interfaceId;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            HttpHeaders headers = httpRequest.headers();
            String httpMethod = httpRequest.method().name();
            if (httpMethod.equalsIgnoreCase("GET") && this.isConnectionUpgrade(headers) && "websocket".equalsIgnoreCase(headers.get("Upgrade"))) {
                log.debug("Upgrading the connection from Http to WebSocket for channel : " + ctx.channel());
                this.handleWebSocketHandshake(httpRequest, ctx);
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    protected boolean isConnectionUpgrade(HttpHeaders headers) {
        if (!headers.contains("Connection")) {
            return false;
        }
        String connectionHeaderValues = headers.get("Connection");
        for (String connectionValue : connectionHeaderValues.split(",")) {
            if (!"Upgrade".equalsIgnoreCase(connectionValue.trim())) continue;
            return true;
        }
        return false;
    }

    private void handleWebSocketHandshake(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        boolean isSecured = false;
        if (ctx.channel().pipeline().get("ssl") != null) {
            isSecured = true;
        }
        String uri = httpRequest.uri();
        WebSocketSessionImpl channelSession = WebSocketUtil.getSession(ctx, isSecured, uri);
        HashMap<String, String> headers = new HashMap<String, String>();
        httpRequest.headers().forEach(header -> {
            String cfr_ignored_0 = (String)headers.put((String)header.getKey(), (String)header.getValue());
        });
        WebSocketSourceHandler webSocketSourceHandler = new WebSocketSourceHandler(this.serverConnectorFuture, isSecured, channelSession, httpRequest, headers, ctx, this.interfaceId);
        WebSocketInitMessageImpl initMessage = new WebSocketInitMessageImpl(ctx, httpRequest, webSocketSourceHandler, headers);
        initMessage.setChannelSession(channelSession);
        initMessage.setIsServerMessage(true);
        initMessage.setTarget(httpRequest.uri());
        initMessage.setListenerInterface(this.interfaceId);
        initMessage.setProperty("SRC_HANDLER", webSocketSourceHandler);
        initMessage.setIsConnectionSecured(isSecured);
        this.serverConnectorFuture.notifyWSListener(initMessage);
    }
}

