/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.config.TransportProperty;
import org.wso2.transport.http.netty.config.TransportsConfiguration;
import org.wso2.transport.http.netty.listener.ServerBootstrapConfiguration;

public class HTTPConnectorUtil {
    public static SenderConfiguration getSenderConfiguration(TransportsConfiguration transportsConfiguration, String scheme) {
        Map<String, SenderConfiguration> senderConfigurations = transportsConfiguration.getSenderConfigurations().stream().collect(Collectors.toMap(senderConf -> senderConf.getScheme().toLowerCase(Locale.getDefault()), config -> config));
        return "https".equals(scheme) ? senderConfigurations.get("https") : senderConfigurations.get("http");
    }

    public static Map<String, Object> getTransportProperties(TransportsConfiguration transportsConfiguration) {
        Map<String, Object> transportProperties = new HashMap<String, Object>();
        Set<TransportProperty> transportPropertiesSet = transportsConfiguration.getTransportProperties();
        if (transportPropertiesSet != null && !transportPropertiesSet.isEmpty()) {
            transportProperties = transportPropertiesSet.stream().collect(Collectors.toMap(TransportProperty::getName, TransportProperty::getValue));
        }
        return transportProperties;
    }

    public static ServerBootstrapConfiguration getServerBootstrapConfiguration(Set<TransportProperty> transportPropertiesSet) {
        Map<String, Object> transportProperties = new HashMap<String, Object>();
        if (transportPropertiesSet != null && !transportPropertiesSet.isEmpty()) {
            transportProperties = transportPropertiesSet.stream().collect(Collectors.toMap(TransportProperty::getName, TransportProperty::getValue));
        }
        ServerBootstrapConfiguration.createBootStrapConfiguration(transportProperties);
        return ServerBootstrapConfiguration.getInstance();
    }

    public static ListenerConfiguration buildListenerConfig(String id, Map<String, String> properties) {
        String host = properties.get("host") != null ? properties.get("host") : "0.0.0.0";
        int port = Integer.parseInt(properties.get("port"));
        ListenerConfiguration config = new ListenerConfiguration(id, host, port);
        String scheme = properties.get("scheme");
        if (scheme != null && scheme.equals("https")) {
            config.setScheme(scheme);
            config.setKeyStoreFile(properties.get("keyStoreFile"));
            config.setKeyStorePass(properties.get("keyStorePassword"));
            config.setCertPass(properties.get("certPassword"));
            if (properties.get("trustStoreFile") != null) {
                config.setTrustStoreFile(properties.get("trustStoreFile"));
            }
            if (properties.get("trustStorePassword") != null) {
                config.setTrustStorePass(properties.get("trustStorePassword"));
            }
            if (properties.get("sslVerifyClient") != null) {
                config.setVerifyClient(properties.get("sslVerifyClient"));
            }
            if (properties.get("tlsStoreType") != null) {
                config.setTlsStoreType(properties.get("tlsStoreType"));
            }
            ArrayList<Parameter> serverParams = new ArrayList<Parameter>();
            if (properties.get("sslEnabledProtocols") != null) {
                Parameter serverProtocols = new Parameter("sslEnabledProtocols", properties.get("sslEnabledProtocols"));
                serverParams.add(serverProtocols);
            }
            if (properties.get("ciphers") != null) {
                Parameter serverCiphers = new Parameter("ciphers", properties.get("ciphers"));
                serverParams.add(serverCiphers);
            }
            if (!serverParams.isEmpty()) {
                config.setParameters(serverParams);
            }
            if (properties.get("sslProtocol") != null) {
                config.setSslProtocol(properties.get("sslProtocol"));
            }
        }
        if (properties.get("keepAlive") != null) {
            config.setKeepAlive(Boolean.valueOf(properties.get("keepAlive")));
        }
        return config;
    }

    public static String getListenerInterface(Map<String, String> parameters) {
        String host = parameters.get("host") != null ? parameters.get("host") : "0.0.0.0";
        int port = Integer.parseInt(parameters.get("port"));
        return host + ":" + port;
    }
}

