/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlSignal;
import org.wso2.transport.http.netty.contract.websocket.WebSocketFrameType;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultWebSocketConnection;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketCloseMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketControlMessageImpl;
import org.wso2.transport.http.netty.exception.UnknownWebSocketFrameTypeException;
import org.wso2.transport.http.netty.internal.websocket.WebSocketUtil;
import org.wso2.transport.http.netty.sender.websocket.WebSocketClient;

public class WebSocketTargetHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private final WebSocketClientHandshaker handshaker;
    private final boolean isSecure;
    private final String requestedUri;
    private final WebSocketConnectorListener connectorListener;
    private String actualSubProtocol = null;
    private DefaultWebSocketConnection webSocketConnection;
    private ChannelPromise handshakeFuture;
    private ChannelHandlerContext ctx;
    private WebSocketFrameType continuationFrameType;

    public WebSocketTargetHandler(WebSocketClientHandshaker handshaker, boolean isSecure, String requestedUri, WebSocketConnectorListener webSocketConnectorListener) {
        this.handshaker = handshaker;
        this.isSecure = isSecure;
        this.requestedUri = requestedUri;
        this.connectorListener = webSocketConnectorListener;
        this.handshakeFuture = null;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public DefaultWebSocketConnection getWebSocketConnection() {
        return this.webSocketConnection;
    }

    public void setActualSubProtocol(String actualSubProtocol) {
        this.actualSubProtocol = actualSubProtocol;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws URISyntaxException {
        this.ctx = ctx;
        this.handshaker.handshake(ctx.channel());
        this.webSocketConnection = WebSocketUtil.getWebSocketConnection(ctx, this.isSecure, this.requestedUri);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws ServerConnectorException {
        if (this.webSocketConnection != null && !this.webSocketConnection.closeFrameReceived() && !this.webSocketConnection.closeFrameSent()) {
            this.notifyCloseMessage(1006, null, ctx);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent idleStateEvent;
        if (evt instanceof IdleStateEvent && (idleStateEvent = (IdleStateEvent)evt).state() == IdleStateEvent.ALL_IDLE_STATE_EVENT.state()) {
            this.notifyIdleTimeout(ctx);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws UnknownWebSocketFrameTypeException, URISyntaxException, ServerConnectorException {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            FullHttpResponse fullHttpResponse = (FullHttpResponse)msg;
            this.handshaker.finishHandshake(ch, fullHttpResponse);
            log.debug("WebSocket Client connected!");
            this.handshakeFuture.setSuccess();
            fullHttpResponse.release();
            this.webSocketConnection = WebSocketUtil.getWebSocketConnection(ctx, this.isSecure, this.requestedUri);
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)msg;
            if (!textFrame.isFinalFragment()) {
                this.continuationFrameType = WebSocketFrameType.TEXT;
            }
            this.notifyTextMessage(textFrame, textFrame.text(), textFrame.isFinalFragment(), ctx);
        } else if (frame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)msg;
            if (!binaryFrame.isFinalFragment()) {
                this.continuationFrameType = WebSocketFrameType.BINARY;
            }
            this.notifyBinaryMessage(binaryFrame, binaryFrame.content(), binaryFrame.isFinalFragment(), ctx);
        } else if (frame instanceof PongWebSocketFrame) {
            this.notifyPongMessage((PongWebSocketFrame)frame, ctx);
        } else if (frame instanceof PingWebSocketFrame) {
            this.notifyPingMessage((PingWebSocketFrame)frame, ctx);
        } else if (frame instanceof CloseWebSocketFrame) {
            this.webSocketConnection.setCloseFrameReceived(true);
            this.notifyCloseMessage((CloseWebSocketFrame)frame, ctx);
        } else if (frame instanceof ContinuationWebSocketFrame) {
            ContinuationWebSocketFrame conframe = (ContinuationWebSocketFrame)msg;
            switch (this.continuationFrameType) {
                case TEXT: {
                    this.notifyTextMessage(conframe, conframe.text(), conframe.isFinalFragment(), ctx);
                    break;
                }
                case BINARY: {
                    this.notifyBinaryMessage(conframe, conframe.content(), conframe.isFinalFragment(), ctx);
                }
            }
        } else {
            throw new UnknownWebSocketFrameTypeException("Cannot identify the WebSocket frame type");
        }
    }

    private void notifyTextMessage(WebSocketFrame frame, String text, boolean finalFragment, ChannelHandlerContext ctx) throws ServerConnectorException {
        WebSocketMessageImpl webSocketTextMessage = WebSocketUtil.getWebSocketMessage(frame, text, finalFragment);
        this.setupCommonProperties(webSocketTextMessage, ctx);
        this.connectorListener.onMessage((WebSocketTextMessage)((Object)webSocketTextMessage));
    }

    private void notifyBinaryMessage(WebSocketFrame frame, ByteBuf content, boolean finalFragment, ChannelHandlerContext ctx) throws ServerConnectorException {
        WebSocketMessageImpl webSocketBinaryMessage = WebSocketUtil.getWebSocketMessage(frame, content, finalFragment);
        this.setupCommonProperties(webSocketBinaryMessage, ctx);
        this.connectorListener.onMessage((WebSocketBinaryMessage)((Object)webSocketBinaryMessage));
    }

    private void notifyCloseMessage(CloseWebSocketFrame closeWebSocketFrame, ChannelHandlerContext ctx) throws ServerConnectorException {
        String reasonText = closeWebSocketFrame.reasonText();
        int statusCode = closeWebSocketFrame.statusCode();
        if (this.webSocketConnection == null) {
            throw new ServerConnectorException("Cannot find initialized channel session");
        }
        WebSocketCloseMessageImpl webSocketCloseMessage = new WebSocketCloseMessageImpl(statusCode, reasonText);
        closeWebSocketFrame.release();
        this.setupCommonProperties(webSocketCloseMessage, ctx);
        this.connectorListener.onMessage(webSocketCloseMessage);
    }

    private void notifyCloseMessage(int statusCode, String reasonText, ChannelHandlerContext ctx) throws ServerConnectorException {
        if (this.webSocketConnection == null) {
            throw new ServerConnectorException("Cannot find initialized channel session");
        }
        WebSocketCloseMessageImpl webSocketCloseMessage = new WebSocketCloseMessageImpl(statusCode, reasonText);
        this.setupCommonProperties(webSocketCloseMessage, ctx);
        this.connectorListener.onMessage(webSocketCloseMessage);
    }

    private void notifyPingMessage(PingWebSocketFrame pingWebSocketFrame, ChannelHandlerContext ctx) throws ServerConnectorException {
        WebSocketControlMessage webSocketControlMessage = WebSocketUtil.getWebsocketControlMessage(pingWebSocketFrame, WebSocketControlSignal.PING);
        this.setupCommonProperties((WebSocketMessageImpl)((Object)webSocketControlMessage), ctx);
        this.connectorListener.onMessage(webSocketControlMessage);
    }

    private void notifyPongMessage(PongWebSocketFrame pongWebSocketFrame, ChannelHandlerContext ctx) throws ServerConnectorException {
        WebSocketControlMessage webSocketControlMessage = WebSocketUtil.getWebsocketControlMessage(pongWebSocketFrame, WebSocketControlSignal.PONG);
        this.setupCommonProperties((WebSocketMessageImpl)((Object)webSocketControlMessage), ctx);
        this.connectorListener.onMessage(webSocketControlMessage);
    }

    private void notifyIdleTimeout(ChannelHandlerContext ctx) throws ServerConnectorException {
        WebSocketControlMessageImpl websocketControlMessage = new WebSocketControlMessageImpl(WebSocketControlSignal.IDLE_TIMEOUT, null);
        this.setupCommonProperties(websocketControlMessage, ctx);
        this.connectorListener.onIdleTimeout(websocketControlMessage);
    }

    private void setupCommonProperties(WebSocketMessageImpl webSocketChannelContext, ChannelHandlerContext ctx) {
        webSocketChannelContext.setSubProtocol(this.actualSubProtocol);
        webSocketChannelContext.setIsConnectionSecured(this.isSecure);
        webSocketChannelContext.setWebSocketConnection(this.webSocketConnection);
        webSocketChannelContext.setIsServerMessage(false);
        webSocketChannelContext.setProperty("SRC_HANDLER", this);
        webSocketChannelContext.setProperty("LISTENER_PORT", ((InetSocketAddress)ctx.channel().localAddress()).getPort());
        webSocketChannelContext.setProperty("LOCAL_ADDRESS", ctx.channel().localAddress());
        webSocketChannelContext.setProperty("LOCAL_NAME", ((InetSocketAddress)ctx.channel().localAddress()).getHostName());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
        this.connectorListener.onError(cause);
    }
}

