/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config.reader;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;

public abstract class ConfigFileReader {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileReader.class);
    private Path configurationFilePath;

    public ConfigFileReader(Path configurationFilePath) {
        this.configurationFilePath = configurationFilePath;
    }

    public abstract Map<String, String> getDeploymentConfiguration() throws ConfigurationException;

    public final String getFileContent() throws ConfigurationException {
        if (this.configurationFilePath == null) {
            String message = "Error while reading the configuration file, file path is null";
            log.error(message);
            throw new ConfigurationException(message);
        }
        try {
            byte[] contentBytes = Files.readAllBytes(this.configurationFilePath);
            return new String(contentBytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String message = "Error while reading configuration file";
            log.error(message, e);
            throw new ConfigurationException(message, e);
        }
    }

    public Path getConfigurationFilePath() {
        return this.configurationFilePath;
    }
}

