/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.formparam.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.wso2.msf4j.formparam.exception.FormUploadException;
import org.wso2.msf4j.formparam.exception.InvalidFileNameException;

public final class StreamUtil {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private StreamUtil() {
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, boolean closeOutputStream) {
        return StreamUtil.copy(inputStream, outputStream, closeOutputStream, new byte[8192]);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, boolean closeOutputStream, byte[] buffer) {
        OutputStream out = outputStream;
        InputStream in = inputStream;
        try {
            int res;
            long total = 0L;
            while ((res = in.read(buffer)) != -1) {
                if (res <= 0) continue;
                total += (long)res;
                if (out == null) continue;
                out.write(buffer, 0, res);
            }
            if (out != null && !closeOutputStream) {
                out.flush();
            }
            long l = total;
            return l;
        }
        catch (IOException e) {
            throw new FormUploadException("Error while copying streams", e);
        }
        finally {
            IOUtils.closeQuietly(in);
            if (closeOutputStream) {
                IOUtils.closeQuietly(out);
            }
        }
    }

    public static String asString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtil.copy(inputStream, baos, true);
        return baos.toString(Charset.defaultCharset().name());
    }

    public static String asString(InputStream inputStream, String encoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtil.copy(inputStream, baos, true);
        return baos.toString(encoding);
    }

    public static String checkFileName(String fileName) {
        if (fileName != null && fileName.indexOf(0) != -1) {
            StringBuilder sb = new StringBuilder();
            block3: for (int i = 0; i < fileName.length(); ++i) {
                char c = fileName.charAt(i);
                switch (c) {
                    case '\u0000': {
                        sb.append("\\0");
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            throw new InvalidFileNameException(fileName, "Invalid file name: " + sb);
        }
        return fileName;
    }
}

