/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.ocsp;

import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.MBeanRegistrar;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.CertificateVerificationException;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.CacheController;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.CacheManager;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.ManageableCache;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.ManageableCacheValue;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.ocsp.OCSPVerifier;

public class OCSPCache
implements ManageableCache {
    private static volatile OCSPCache cache;
    private static volatile Map<BigInteger, OCSPCacheValue> hashMap;
    private volatile Iterator<Map.Entry<BigInteger, OCSPCacheValue>> iterator = hashMap.entrySet().iterator();
    private volatile CacheManager cacheManager;
    private static final Logger LOG;

    private OCSPCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OCSPCache getCache() {
        if (cache != null) return cache;
        Class<OCSPCache> clazz = OCSPCache.class;
        synchronized (OCSPCache.class) {
            if (cache != null) return cache;
            cache = new OCSPCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(int size, int delay) {
        if (this.cacheManager != null) return;
        Class<OCSPCache> clazz = OCSPCache.class;
        synchronized (OCSPCache.class) {
            if (this.cacheManager != null) return;
            this.cacheManager = new CacheManager(cache, size, delay);
            CacheController mbean = new CacheController(cache, this.cacheManager);
            MBeanRegistrar.getInstance().registerMBean(mbean, "CacheController", "OCSPCacheController");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ManageableCacheValue getNextCacheValue() {
        if (this.iterator.hasNext()) {
            return hashMap.get(this.iterator.next().getKey());
        }
        this.resetIterator();
        return null;
    }

    @Override
    public int getCacheSize() {
        return hashMap.size();
    }

    @Override
    public void resetIterator() {
        this.iterator = hashMap.entrySet().iterator();
    }

    public synchronized SingleResp getCacheValue(BigInteger serialNumber) {
        OCSPCacheValue cacheValue = hashMap.get(serialNumber);
        if (cacheValue == null) {
            return null;
        }
        if (!cacheValue.isValid()) {
            cacheValue.updateCacheWithNewValue();
            OCSPCacheValue ocspCacheValue = hashMap.get(serialNumber);
            return ocspCacheValue != null ? ocspCacheValue.getValue() : null;
        }
        return cacheValue.getValue();
    }

    public synchronized OCSPResp getOCSPCacheValue(BigInteger serialNumber) {
        OCSPCacheValue cacheValue = hashMap.get(serialNumber);
        if (cacheValue != null) {
            if (!cacheValue.isValid()) {
                cacheValue.updateCacheWithNewValue();
                OCSPCacheValue ocspCacheValue = hashMap.get(serialNumber);
                return ocspCacheValue != null ? ocspCacheValue.getOCSPValue() : null;
            }
            return cacheValue.getOCSPValue();
        }
        return null;
    }

    public synchronized void setCacheValue(OCSPResp ocspResp, BigInteger serialNumber, SingleResp singleResp, OCSPReq request, String serviceUrl) {
        OCSPCacheValue cacheValue = new OCSPCacheValue(ocspResp, serialNumber, singleResp, request, serviceUrl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before setting - HashMap size {}", (Object)hashMap.size());
        }
        hashMap.put(serialNumber, cacheValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After setting - HashMap size {}", (Object)hashMap.size());
        }
    }

    public synchronized void removeCacheValue(BigInteger serialNumber) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before removing - HashMap size {}", (Object)hashMap.size());
        }
        hashMap.remove(serialNumber);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After removing - HashMap size {}", (Object)hashMap.size());
        }
    }

    static {
        hashMap = new ConcurrentHashMap<BigInteger, OCSPCacheValue>();
        LOG = LoggerFactory.getLogger(OCSPCache.class);
    }

    private class OCSPCacheValue
    implements ManageableCacheValue {
        private BigInteger serialNumber;
        private SingleResp singleResp;
        private OCSPReq request;
        private String serviceUrl;
        private OCSPResp ocspResp;
        private long timeStamp = System.currentTimeMillis();

        public OCSPCacheValue(OCSPResp ocspResp, BigInteger serialNumber, SingleResp singleResp, OCSPReq request, String serviceUrl) {
            this.serialNumber = serialNumber;
            this.singleResp = singleResp;
            this.request = request;
            this.serviceUrl = serviceUrl;
            this.ocspResp = ocspResp;
        }

        public BigInteger getKey() {
            return this.serialNumber;
        }

        public SingleResp getValue() {
            this.timeStamp = System.currentTimeMillis();
            return this.singleResp;
        }

        public OCSPResp getOCSPValue() {
            this.timeStamp = System.currentTimeMillis();
            return this.ocspResp;
        }

        @Override
        public boolean isValid() {
            Date now = new Date();
            Date nextUpdate = this.singleResp.getNextUpdate();
            return nextUpdate != null && nextUpdate.after(now);
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public void removeThisCacheValue() {
            OCSPCache.this.removeCacheValue(this.serialNumber);
        }

        @Override
        public void updateCacheWithNewValue() {
            this.replaceNewCacheValue();
        }

        private synchronized void replaceNewCacheValue() {
            if (this.isValid()) {
                return;
            }
            try {
                SingleResp[] responses;
                OCSPResp response = OCSPVerifier.getOCSPResponce(this.serviceUrl, this.request);
                if (0 != response.getStatus()) {
                    throw new CertificateVerificationException("OCSP response status was not SUCCESSFUL. Found OCSPResponseStatus:" + response.getStatus());
                }
                BasicOCSPResp basicResponse = (BasicOCSPResp)response.getResponseObject();
                SingleResp[] singleRespArray = responses = basicResponse == null ? null : basicResponse.getResponses();
                if (responses == null) {
                    throw new CertificateVerificationException("Unable to get OCSP response.");
                }
                SingleResp resp = responses[0];
                OCSPCache.this.setCacheValue(response, this.serialNumber, resp, this.request, this.serviceUrl);
            }
            catch (OCSPException | CertificateVerificationException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Can not replace old CacheValue with new CacheValue. So removing ocsp cache value", e);
                }
                this.removeThisCacheValue();
            }
        }
    }
}

