/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http2.Http2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.SendingEntityBody;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.SendingHeaders;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ReceivingEntityBody
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingEntityBody.class);
    private final Http2MessageStateContext http2MessageStateContext;
    private boolean headerSent;

    ReceivingEntityBody(Http2MessageStateContext http2MessageStateContext) {
        this.http2MessageStateContext = http2MessageStateContext;
    }

    ReceivingEntityBody(Http2MessageStateContext http2MessageStateContext, boolean headerSent) {
        this(http2MessageStateContext);
        this.headerSent = headerSent;
    }

    @Override
    public void readInboundRequestHeaders(Http2HeadersFrame headersFrame) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) {
        int streamId = dataFrame.getStreamId();
        ByteBuf data = dataFrame.getData();
        HttpCarbonMessage sourceReqCMsg = http2SourceHandler.getStreamIdRequestMap().get(streamId);
        if (sourceReqCMsg != null) {
            if (dataFrame.isEndOfStream()) {
                sourceReqCMsg.addHttpContent(new DefaultLastHttpContent(data));
                sourceReqCMsg.setLastHttpContentArrived();
                http2SourceHandler.getStreamIdRequestMap().remove(streamId);
                this.http2MessageStateContext.setListenerState(new EntityBodyReceived(this.http2MessageStateContext));
            } else {
                sourceReqCMsg.addHttpContent(new DefaultHttpContent(data));
            }
        } else {
            LOG.warn("Inconsistent state detected : data has been received before headers");
        }
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        if (this.headerSent) {
            this.http2MessageStateContext.setListenerState(new SendingEntityBody(http2OutboundRespListener, this.http2MessageStateContext));
            this.http2MessageStateContext.getListenerState().writeOutboundResponseBody(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
        } else {
            this.http2MessageStateContext.setListenerState(new SendingHeaders(http2OutboundRespListener, this.http2MessageStateContext));
            this.http2MessageStateContext.getListenerState().writeOutboundResponseHeaders(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
        }
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) throws Http2Exception {
        Http2StateUtil.writeHttp2Promise(pushPromise, http2OutboundRespListener.getChannelHandlerContext(), http2OutboundRespListener.getConnection(), http2OutboundRespListener.getEncoder(), http2OutboundRespListener.getInboundRequestMsg(), http2OutboundRespListener.getInboundRequestMsg().getHttpOutboundRespStatusFuture(), http2OutboundRespListener.getOriginalStreamId());
    }
}

