/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.BackPressureListener;

public class DefaultBackPressureListener
implements BackPressureListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBackPressureListener.class);
    private Semaphore semaphore = new Semaphore(0);

    @Override
    public void onUnWritable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Semaphore acquired.");
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onWritable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Semaphore released.");
        }
        this.semaphore.release();
    }
}

