/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpAsyncRequestControl;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpAsyncRequestControl;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;

public class ServletServerHttpRequest
implements ServerHttpRequest {
    protected static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected static final String FORM_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private final HttpServletRequest servletRequest;
    private HttpHeaders headers;
    private ServerHttpAsyncRequestControl asyncRequestControl;

    public ServletServerHttpRequest(HttpServletRequest servletRequest) {
        Assert.notNull(servletRequest, "HttpServletRequest must not be null");
        this.servletRequest = servletRequest;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.servletRequest.getMethod());
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.servletRequest.getScheme(), null, this.servletRequest.getServerName(), this.servletRequest.getServerPort(), this.servletRequest.getRequestURI(), this.servletRequest.getQueryString(), null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get HttpServletRequest URI: " + ex.getMessage(), ex);
        }
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            int requestContentLength;
            String requestEncoding;
            String requestContentType;
            this.headers = new HttpHeaders();
            Enumeration headerNames = this.servletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = this.servletRequest.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    this.headers.add(headerName, headerValue);
                }
            }
            MediaType contentType = this.headers.getContentType();
            if (contentType == null && StringUtils.hasLength(requestContentType = this.servletRequest.getContentType())) {
                contentType = MediaType.parseMediaType(requestContentType);
                this.headers.setContentType(contentType);
            }
            if (contentType != null && contentType.getCharSet() == null && StringUtils.hasLength(requestEncoding = this.servletRequest.getCharacterEncoding())) {
                Charset charSet = Charset.forName(requestEncoding);
                LinkedCaseInsensitiveMap<String> params = new LinkedCaseInsensitiveMap<String>();
                params.putAll(contentType.getParameters());
                params.put("charset", charSet.toString());
                MediaType newContentType = new MediaType(contentType.getType(), contentType.getSubtype(), params);
                this.headers.setContentType(newContentType);
            }
            if (this.headers.getContentLength() == -1L && (requestContentLength = this.servletRequest.getContentLength()) != -1) {
                this.headers.setContentLength(requestContentLength);
            }
        }
        return this.headers;
    }

    @Override
    public Principal getPrincipal() {
        return this.servletRequest.getUserPrincipal();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.servletRequest.getLocalName(), this.servletRequest.getLocalPort());
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.servletRequest.getRemoteHost(), this.servletRequest.getRemotePort());
    }

    @Override
    public InputStream getBody() throws IOException {
        if (this.isFormPost(this.servletRequest)) {
            return this.getBodyFromServletRequestParameters(this.servletRequest);
        }
        return this.servletRequest.getInputStream();
    }

    private boolean isFormPost(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().contains(FORM_CONTENT_TYPE) && METHOD_POST.equalsIgnoreCase(request.getMethod());
    }

    private InputStream getBodyFromServletRequestParameters(HttpServletRequest request) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, FORM_CHARSET);
        Map form = request.getParameterMap();
        Iterator nameIterator = form.keySet().iterator();
        while (nameIterator.hasNext()) {
            String name = (String)nameIterator.next();
            List<Object> values = Arrays.asList((Object[])form.get(name));
            Iterator<Object> valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                String value = (String)valueIterator.next();
                writer.write(URLEncoder.encode(name, FORM_CHARSET));
                if (value == null) continue;
                ((Writer)writer).write(61);
                writer.write(URLEncoder.encode(value, FORM_CHARSET));
                if (!valueIterator.hasNext()) continue;
                ((Writer)writer).write(38);
            }
            if (!nameIterator.hasNext()) continue;
            writer.append('&');
        }
        ((Writer)writer).flush();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    @Override
    public ServerHttpAsyncRequestControl getAsyncRequestControl(ServerHttpResponse response) {
        if (this.asyncRequestControl == null) {
            Assert.isInstanceOf(ServletServerHttpResponse.class, response);
            ServletServerHttpResponse servletServerResponse = (ServletServerHttpResponse)response;
            this.asyncRequestControl = new ServletServerHttpAsyncRequestControl(this, servletServerResponse);
        }
        return this.asyncRequestControl;
    }
}

