/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.websocket.CloseReason;
import javax.websocket.PongMessage;
import javax.websocket.server.PathParam;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.internal.router.PatternPathRouter;
import org.wso2.msf4j.internal.websocket.CloseCodeImpl;
import org.wso2.msf4j.internal.websocket.EndpointDispatcher;
import org.wso2.msf4j.internal.websocket.EndpointsRegistryImpl;
import org.wso2.msf4j.internal.websocket.WebSocketPongMessage;
import org.wso2.msf4j.websocket.exception.WebSocketEndpointMethodReturnTypeException;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;

@Component(name="org.wso2.msf4j.internal.MSF4JWSConnectorListener", immediate=true, service={WebSocketConnectorListener.class})
public class MSF4JWSConnectorListener
implements WebSocketConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(MSF4JWSConnectorListener.class);

    @Override
    public void onHandshake(final WebSocketHandshaker webSocketHandshaker) {
        ServerHandshakeFuture handshakeFuture = webSocketHandshaker.handshake();
        handshakeFuture.setHandshakeListener(new ServerHandshakeListener(){

            @Override
            public void onSuccess(WebSocketConnection webSocketConnection) {
                MSF4JWSConnectorListener.this.handleWebSocketHandshake(webSocketHandshaker, webSocketConnection);
                webSocketConnection.startReadingFrames();
            }

            @Override
            public void onError(Throwable throwable) {
                log.error("Unexpected error occur while handshake.", throwable);
            }
        });
    }

    @Override
    public void onMessage(WebSocketTextMessage webSocketTextMessage) {
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        String uri = webSocketTextMessage.getTarget();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(uri);
        this.handleTextWebSocketMessage(webSocketTextMessage, routableEndpoint, webSocketTextMessage.getWebSocketConnection());
    }

    @Override
    public void onMessage(WebSocketBinaryMessage webSocketBinaryMessage) {
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        String uri = webSocketBinaryMessage.getTarget();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(uri);
        this.handleBinaryWebSocketMessage(webSocketBinaryMessage, routableEndpoint, webSocketBinaryMessage.getWebSocketConnection());
    }

    @Override
    public void onMessage(WebSocketControlMessage webSocketControlMessage) {
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        String uri = webSocketControlMessage.getTarget();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(uri);
        this.handleControlCarbonMessage(webSocketControlMessage, routableEndpoint, webSocketControlMessage.getWebSocketConnection());
    }

    @Override
    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        String uri = webSocketCloseMessage.getTarget();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(uri);
        this.handleCloseWebSocketMessage(webSocketCloseMessage, routableEndpoint, webSocketCloseMessage.getWebSocketConnection());
    }

    @Override
    public void onClose(WebSocketConnection webSocketConnection) {
    }

    @Override
    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        log.error("Unexpected error occur.", throwable);
    }

    @Override
    public void onIdleTimeout(WebSocketControlMessage webSocketControlMessage) {
    }

    private boolean handleWebSocketHandshake(WebSocketHandshaker carbonMessage, WebSocketConnection webSocketConnection) {
        String requestUri;
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(requestUri = carbonMessage.getTarget());
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while connecting to server. Routable endpoint is not registered for the request uri:" + requestUri);
        }
        Optional<Method> methodOptional = new EndpointDispatcher().getOnOpenMethod(routableEndpoint.getDestination());
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        try {
            LinkedList parameterList = new LinkedList();
            methodOptional.ifPresent(method -> {
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == WebSocketConnection.class) {
                        parameterList.add(webSocketConnection);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else if (parameter.getType() == HttpCarbonRequest.class) {
                        parameterList.add(carbonMessage.getHttpCarbonRequest());
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, routableEndpoint.getDestination(), parameterList, webSocketConnection);
            });
            return true;
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, webSocketConnection);
            return false;
        }
    }

    private void handleTextWebSocketMessage(WebSocketTextMessage textCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, WebSocketConnection webSocketConnection) {
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while handling the message. Routable endpoint is not registered for the request uri:" + textCarbonMessage.getTarget());
        }
        Object endpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnStringMessageMethod(endpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam == null) {
                            parameterList.add(textCarbonMessage.getText());
                        } else {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else if (parameter.getType() == WebSocketConnection.class) {
                        parameterList.add(webSocketConnection);
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, endpoint, (List<Object>)parameterList, webSocketConnection);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, webSocketConnection);
        }
    }

    private void handleBinaryWebSocketMessage(WebSocketBinaryMessage binaryCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, WebSocketConnection webSocketConnection) {
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while handling the message. Routable endpoint is not registered for the request uri:" + binaryCarbonMessage.getTarget());
        }
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnBinaryMessageMethod(webSocketEndpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == ByteBuffer.class) {
                        parameterList.add(binaryCarbonMessage.getByteBuffer());
                    } else if (parameter.getType() == byte[].class) {
                        ByteBuffer buffer = binaryCarbonMessage.getByteBuffer();
                        byte[] bytes = new byte[buffer.capacity()];
                        for (int i = 0; i < buffer.capacity(); ++i) {
                            bytes[i] = buffer.get();
                        }
                        parameterList.add(bytes);
                    } else if (parameter.getType() == Boolean.TYPE) {
                        parameterList.add(binaryCarbonMessage.isFinalFragment());
                    } else if (parameter.getType() == WebSocketConnection.class) {
                        parameterList.add(webSocketConnection);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, webSocketConnection);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, webSocketConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCloseWebSocketMessage(WebSocketCloseMessage closeCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, WebSocketConnection webSocketConnection) {
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while handling the message. Routable endpoint is not registered for the request uri:" + closeCarbonMessage.getTarget());
        }
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnCloseMethod(webSocketEndpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == CloseReason.class) {
                        CloseCodeImpl closeCode = new CloseCodeImpl(closeCarbonMessage.getCloseCode());
                        CloseReason closeReason = new CloseReason(closeCode, closeCarbonMessage.getCloseReason());
                        parameterList.add(closeReason);
                    } else if (parameter.getType() == WebSocketConnection.class) {
                        parameterList.add(webSocketConnection);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, webSocketConnection);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, webSocketConnection);
        }
        finally {
            if (webSocketConnection.isOpen()) {
                webSocketConnection.terminateConnection();
            }
        }
    }

    private void handleControlCarbonMessage(WebSocketControlMessage controlCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, WebSocketConnection webSocketConnection) {
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while handling the message. Routable endpoint is not registered for the request uri:" + controlCarbonMessage.getTarget());
        }
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnPongMessageMethod(webSocketEndpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == PongMessage.class) {
                        parameterList.add(new WebSocketPongMessage(controlCarbonMessage.getByteBuffer()));
                    } else if (parameter.getType() == WebSocketConnection.class) {
                        parameterList.add(webSocketConnection);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, webSocketConnection);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, webSocketConnection);
        }
    }

    private void handleError(Throwable throwable, PatternPathRouter.RoutableDestination<Object> routableEndpoint, WebSocketConnection webSocketConnection) {
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnErrorMethod(webSocketEndpoint);
        methodOptional.ifPresent(method -> {
            LinkedList<Object> parameterList = new LinkedList<Object>();
            Arrays.stream(method.getParameters()).forEach(parameter -> {
                if (parameter.getType() == Throwable.class) {
                    parameterList.add(throwable);
                } else if (parameter.getType() == WebSocketConnection.class) {
                    parameterList.add(webSocketConnection);
                } else if (parameter.getType() == String.class) {
                    PathParam pathParam = parameter.getAnnotation(PathParam.class);
                    if (pathParam != null) {
                        parameterList.add(paramValues.get(pathParam.value()));
                    }
                } else {
                    parameterList.add(null);
                }
            });
            this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, webSocketConnection);
        });
    }

    private void executeMethod(Method method, Object webSocketEndpoint, List<Object> parameterList, WebSocketConnection webSocketConnection) {
        block9: {
            try {
                if (method.getReturnType() == String.class) {
                    String returnStr = (String)method.invoke(webSocketEndpoint, parameterList.toArray());
                    webSocketConnection.pushText(returnStr);
                    break block9;
                }
                if (method.getReturnType() == ByteBuffer.class) {
                    ByteBuffer buffer = (ByteBuffer)method.invoke(webSocketEndpoint, parameterList.toArray());
                    webSocketConnection.pushBinary(buffer);
                    break block9;
                }
                if (method.getReturnType() == byte[].class) {
                    byte[] bytes = (byte[])method.invoke(webSocketEndpoint, parameterList.toArray());
                    webSocketConnection.pushBinary(ByteBuffer.wrap(bytes));
                    break block9;
                }
                if (method.getReturnType() == Void.TYPE) {
                    method.invoke(webSocketEndpoint, parameterList.toArray());
                    break block9;
                }
                if (method.getReturnType() == PongMessage.class) {
                    PongMessage pongMessage = (PongMessage)method.invoke(webSocketEndpoint, parameterList.toArray());
                    webSocketConnection.pong(pongMessage.getApplicationData());
                    break block9;
                }
                throw new WebSocketEndpointMethodReturnTypeException("Unknown return type.");
            }
            catch (IllegalAccessException e) {
                log.error("Illegal access exception occurred: " + e.toString());
            }
            catch (InvocationTargetException e) {
                log.error("Method invocation failed: " + e.toString());
            }
            catch (WebSocketEndpointMethodReturnTypeException e) {
                log.error("WebSocket method return type exception occurred: " + e.toString());
            }
        }
    }
}

