/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.spring.property;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlFileApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String YAML_CONFIG_FILE_NAME = "application.yml";

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        Resource resource = applicationContext.getResource("classpath:application.yml");
        if (!resource.exists()) {
            resource = applicationContext.getResource("file:application.yml");
        }
        if (resource.exists()) {
            ArrayList<Properties> applicationYmlProperties = new ArrayList<Properties>();
            String[] activeProfileNames = null;
            try (InputStream input = resource.getInputStream();){
                Yaml yml = new Yaml(new SafeConstructor());
                Iterable<Object> objects = yml.loadAll(input);
                for (Object obj : objects) {
                    Map<String, Object> flattenedMap = this.getFlattenedMap(this.asMap(obj));
                    Properties properties = new Properties();
                    properties.putAll(flattenedMap);
                    Object activeProfile = properties.get("spring.profiles.active");
                    if (activeProfile != null) {
                        activeProfileNames = activeProfile.toString().split(",");
                    }
                    applicationYmlProperties.add(properties);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Couldn't find application.yml", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading application.yml", e);
            }
            if (activeProfileNames == null) {
                activeProfileNames = applicationContext.getEnvironment().getActiveProfiles();
            }
            for (Properties properties : applicationYmlProperties) {
                MapPropertySource propertySource;
                String profile = properties.getProperty("spring.profiles");
                if (profile == null) {
                    propertySource = new MapPropertySource(YAML_CONFIG_FILE_NAME, (Map<String, Object>)new HashMap<Object, Object>(properties));
                    applicationContext.getEnvironment().getPropertySources().addLast(propertySource);
                } else if (activeProfileNames != null && ("default".equals(profile) || activeProfileNames.length == 1 && activeProfileNames[0].equals(profile))) {
                    propertySource = new MapPropertySource("application.yml[" + profile + "]", (Map<String, Object>)new HashMap<Object, Object>(properties));
                    applicationContext.getEnvironment().getPropertySources().addAfter("systemEnvironment", propertySource);
                }
                activeProfileNames = applicationContext.getEnvironment().getActiveProfiles();
            }
        }
        applicationContext.getEnvironment().getActiveProfiles();
    }

    private Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key;
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = this.asMap(value);
            }
            if ((key = entry.getKey()) instanceof CharSequence) {
                result.put(key.toString(), value);
                continue;
            }
            result.put("[" + key.toString() + "]", value);
        }
        return result;
    }

    private final Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(result, source, null);
        return result;
    }

    private void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (StringUtils.hasText(path)) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value == null ? "" : value);
        }
    }
}

