/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.samples.claims.manager;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClaimManagerProxy {
    private static final Logger logger = Logger.getLogger(ClaimManagerProxy.class.getName());
    private static final String externalClaimSoapAction = "getExternalClaims";
    private static final String localClaimSoapAction = "getLocalClaims";
    private final String claimManagementUrl;
    private final String identityServerUsername;
    private final String identityServerPassword;
    private final List<Node> oidcDialectNodes;
    private final List<Node> localClaimNodes;

    public ClaimManagerProxy(String claimManagementUrl, String identityServerUsername, String identityServerPassword) {
        this.claimManagementUrl = claimManagementUrl;
        this.identityServerUsername = identityServerUsername;
        this.identityServerPassword = identityServerPassword;
        this.oidcDialectNodes = this.getOIDCDialectNodes();
        this.localClaimNodes = this.getLocalClaimNodes();
    }

    public Map<String, String> getOidcClaimDisplayNameMapping(List<String> oidcClaims) {
        HashMap<String, String> oidcClaimToLocalUriClaimMapping = new HashMap<String, String>();
        for (Node node : this.oidcDialectNodes) {
            String prefix;
            Element nsElement = (Element)node;
            NodeList externalClaimUrlNodes = nsElement.getElementsByTagName((prefix = nsElement.getAttribute("xsi:type").split(":")[0]) + ":externalClaimURI");
            if (externalClaimUrlNodes.getLength() != 1 || !oidcClaims.contains(externalClaimUrlNodes.item(0).getTextContent())) continue;
            NodeList mappedLocalClaimUriNodes = nsElement.getElementsByTagName(prefix + ":mappedLocalClaimURI");
            if (mappedLocalClaimUriNodes.getLength() == 1) {
                oidcClaimToLocalUriClaimMapping.put(externalClaimUrlNodes.item(0).getTextContent(), mappedLocalClaimUriNodes.item(0).getTextContent());
                continue;
            }
            oidcClaimToLocalUriClaimMapping.put(externalClaimUrlNodes.item(0).getTextContent(), externalClaimUrlNodes.item(0).getTextContent());
        }
        HashMap<String, String> oidcClaimDisplayValueMap = new HashMap<String, String>();
        Map<String, String> claimUriDisplayValueMappings = this.getLocalClaimUriDisplayValueMapping(new ArrayList<String>(oidcClaimToLocalUriClaimMapping.values()));
        for (String claim : oidcClaimToLocalUriClaimMapping.keySet()) {
            oidcClaimDisplayValueMap.put(claim, claimUriDisplayValueMappings.get(oidcClaimToLocalUriClaimMapping.get(claim)));
        }
        return oidcClaimDisplayValueMap;
    }

    public Map<String, String> getLocalClaimUriDisplayValueMapping(List<String> localClaimUriList) {
        HashMap<String, String> claimDisplayValueMap = new HashMap<String, String>();
        for (Node node : this.localClaimNodes) {
            Element nsElement = (Element)node;
            String prefix = nsElement.getAttribute("xsi:type").split(":")[0];
            NodeList localClaimUriElement = nsElement.getElementsByTagName(prefix + ":localClaimURI");
            String claimUri = localClaimUriElement.item(0).getTextContent();
            if (localClaimUriElement.getLength() != 1 || !localClaimUriList.contains(claimUri)) continue;
            String displayValue = ClaimManagerProxy.getDisplayValueFromNodeList(nsElement.getElementsByTagName(prefix + ":claimProperties"));
            if (displayValue != null) {
                claimDisplayValueMap.put(claimUri, displayValue);
                continue;
            }
            claimDisplayValueMap.put(claimUri, claimUri);
        }
        return claimDisplayValueMap;
    }

    private static String getDisplayValueFromNodeList(NodeList claimPropertyNodes) {
        for (int j = 0; j < claimPropertyNodes.getLength(); ++j) {
            NodeList propertyChildren = claimPropertyNodes.item(j).getChildNodes();
            for (int k = 0; k < propertyChildren.getLength(); ++k) {
                if (!"DisplayName".equals(propertyChildren.item(k).getTextContent())) continue;
                if (k == 0) {
                    return propertyChildren.item(1).getTextContent();
                }
                return propertyChildren.item(0).getTextContent();
            }
        }
        return null;
    }

    private List<Node> getOIDCDialectNodes() {
        String oidcDilectSoapBody = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://org.apache.axis2/xsd\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <xsd:getExternalClaims>\n         <xsd:externalClaimDialectURI>http://wso2.org/oidc/claim</xsd:externalClaimDialectURI>\n      </xsd:getExternalClaims>\n   </soapenv:Body>\n</soapenv:Envelope>";
        String claimManagementResponse = this.getClaimManagementResponse("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://org.apache.axis2/xsd\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <xsd:getExternalClaims>\n         <xsd:externalClaimDialectURI>http://wso2.org/oidc/claim</xsd:externalClaimDialectURI>\n      </xsd:getExternalClaims>\n   </soapenv:Body>\n</soapenv:Envelope>", externalClaimSoapAction);
        ArrayList<Node> oidcNodes = new ArrayList<Node>();
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xmlDocument = documentBuilder.parse(new ByteArrayInputStream(claimManagementResponse.getBytes()));
            NodeList nsReturnElements = xmlDocument.getElementsByTagName("ns:return");
            for (int i = 0; i < nsReturnElements.getLength(); ++i) {
                oidcNodes.add(nsReturnElements.item(i));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.log(Level.SEVERE, "Error while parsing claim SOAP response. Response will be ignored", e);
        }
        return oidcNodes;
    }

    private List<Node> getLocalClaimNodes() {
        String localClaimSoapBody = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://org.apache.axis2/xsd\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <xsd:getLocalClaims/>\n   </soapenv:Body>\n</soapenv:Envelope>";
        String claimManagementResponse = this.getClaimManagementResponse("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://org.apache.axis2/xsd\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <xsd:getLocalClaims/>\n   </soapenv:Body>\n</soapenv:Envelope>", localClaimSoapAction);
        ArrayList<Node> localClaimNodes = new ArrayList<Node>();
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xmlDocument = documentBuilder.parse(new ByteArrayInputStream(claimManagementResponse.getBytes()));
            NodeList nsReturnElements = xmlDocument.getElementsByTagName("ns:return");
            for (int i = 0; i < nsReturnElements.getLength(); ++i) {
                localClaimNodes.add(nsReturnElements.item(i));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.log(Level.SEVERE, "Error while parsing claim SOAP response. Response will be ignored", e);
        }
        return localClaimNodes;
    }

    private String getClaimManagementResponse(String soapBody, String soapAction) {
        try {
            String line;
            URL url = new URL(this.claimManagementUrl);
            HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "text/xml");
            urlConnection.setRequestProperty("Authorization", ClaimManagerProxy.getAuthHeader(this.identityServerUsername, this.identityServerPassword));
            urlConnection.setRequestProperty("SOAPAction", soapAction);
            OutputStream outputStream = urlConnection.getOutputStream();
            outputStream.write(soapBody.getBytes());
            outputStream.close();
            urlConnection.connect();
            InputStreamReader inputStreamReader = new InputStreamReader(urlConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder soapResponseBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                soapResponseBuilder.append(line);
            }
            return soapResponseBuilder.toString();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while retrieving response", e);
            throw new RuntimeException("Error while retrieving response", e);
        }
    }

    private static String getAuthHeader(String username, String password) {
        String base64Part = new String(Base64.getEncoder().encode(String.join((CharSequence)":", username, password).getBytes()));
        return String.join((CharSequence)" ", "Basic", base64Part);
    }
}

