/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.samples.workflow.template.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.wso2.carbon.identity.samples.workflow.template.SampleTemplate;
import org.wso2.carbon.identity.samples.workflow.template.SampleTemplateImplementation;
import org.wso2.carbon.identity.workflow.impl.BPELDeployer;
import org.wso2.carbon.identity.workflow.impl.RequestExecutor;
import org.wso2.carbon.identity.workflow.mgt.exception.WorkflowRuntimeException;
import org.wso2.carbon.identity.workflow.mgt.template.AbstractTemplate;
import org.wso2.carbon.identity.workflow.mgt.util.WorkflowManagementUtil;
import org.wso2.carbon.identity.workflow.mgt.workflow.AbstractWorkflow;

@Component(name="identity.samples.workflow.template.component", immediate=true)
public class WorkflowTemplateServiceComponent {
    private static Log log = LogFactory.getLog(WorkflowTemplateServiceComponent.class);

    @Activate
    protected void activate(ComponentContext componentContext) {
        try {
            BundleContext bundleContext = componentContext.getBundleContext();
            bundleContext.registerService(AbstractTemplate.class, (Object)new SampleTemplate(this.readFileContent("SampleTemplateMetaData.xml")), null);
            bundleContext.registerService(AbstractWorkflow.class, (Object)new SampleTemplateImplementation(BPELDeployer.class, RequestExecutor.class, this.readFileContent("SampleWorkflowImplMetaData.xml")), null);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating WorkflowTemplateServiceComponent bundle.", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping WorkflowTemplateServiceComponent");
        }
    }

    private String readFileContent(String fileName) throws WorkflowRuntimeException {
        String content;
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(fileName);){
            content = WorkflowManagementUtil.readFileFromResource((InputStream)resourceAsStream);
        }
        catch (IOException | URISyntaxException e) {
            String errorMsg = "Error occurred while reading file from class path, " + e.getMessage();
            log.error((Object)errorMsg);
            throw new WorkflowRuntimeException(errorMsg, (Throwable)e);
        }
        return content;
    }
}

