/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.sample;

import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.core.util.EventPrinter;

public class TimeWindowSample {
    public static void main(String[] args) throws InterruptedException {
        String siddhiApp = "define stream StockEventStream (symbol string, price float, volume long);  @info(name = 'query1') from StockEventStream#window.time(5 sec)  select symbol, sum(price) as price, sum(volume) as volume group by symbol insert into AggregateStockStream ;";
        SiddhiManager siddhiManager = new SiddhiManager();
        SiddhiAppRuntime siddhiAppRuntime = siddhiManager.createSiddhiAppRuntime(siddhiApp);
        siddhiAppRuntime.addCallback("AggregateStockStream", new StreamCallback(){

            public void receive(Event[] events) {
                EventPrinter.print((Event[])events);
            }
        });
        InputHandler inputHandler = siddhiAppRuntime.getInputHandler("StockEventStream");
        siddhiAppRuntime.start();
        inputHandler.send(new Object[]{"IBM", Float.valueOf(100.0f), 100L});
        Thread.sleep(1000L);
        inputHandler.send(new Object[]{"IBM", Float.valueOf(200.0f), 300L});
        inputHandler.send(new Object[]{"WSO2", Float.valueOf(60.0f), 200L});
        Thread.sleep(1000L);
        inputHandler.send(new Object[]{"WSO2", Float.valueOf(70.0f), 400L});
        inputHandler.send(new Object[]{"GOOG", Float.valueOf(50.0f), 30L});
        Thread.sleep(1000L);
        inputHandler.send(new Object[]{"IBM", Float.valueOf(200.0f), 400L});
        Thread.sleep(2000L);
        inputHandler.send(new Object[]{"WSO2", Float.valueOf(70.0f), 50L});
        Thread.sleep(2000L);
        inputHandler.send(new Object[]{"WSO2", Float.valueOf(80.0f), 400L});
        inputHandler.send(new Object[]{"GOOG", Float.valueOf(60.0f), 30L});
        Thread.sleep(1000L);
        siddhiAppRuntime.shutdown();
        siddhiManager.shutdown();
    }
}

