/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.annotation.processor;

import java.text.MessageFormat;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.processor.AbstractAnnotationProcessor;
import org.wso2.siddhi.annotation.util.AnnotationValidationException;

public class FunctionExecutorValidationAnnotationProcessor
extends AbstractAnnotationProcessor {
    public FunctionExecutorValidationAnnotationProcessor(String extensionClassFullName) {
        super(extensionClassFullName);
    }

    @Override
    public void parameterValidation(Parameter[] parameters) throws AnnotationValidationException {
        for (Parameter parameter : parameters) {
            String parameterName = parameter.name();
            if (parameterName.isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name annotated in class {0} is null or empty.", this.extensionClassFullName));
            }
            if (!PARAMETER_NAME_PATTERN.matcher(parameterName).find()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} annotated in class {1} is not in proper format ''abc.def.ghi''.", parameterName, this.extensionClassFullName));
            }
            if (parameter.description().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> description annotated in class {1} is null or empty.", parameterName, this.extensionClassFullName));
            }
            if (parameter.type().length == 0) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> type annotated in class {1} is null or empty.", parameterName, this.extensionClassFullName));
            }
            if (parameter.dynamic()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> dynamic property cannot be true annotated in class {1}.", parameterName, this.extensionClassFullName));
            }
            if (!parameter.optional() || !parameter.defaultValue().isEmpty()) continue;
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> defaultValue annotated in class {1} cannot be null or empty for the optional parameter.", parameterName, this.extensionClassFullName));
        }
    }

    @Override
    public void returnAttributesValidation(ReturnAttribute[] returnAttributes) throws AnnotationValidationException {
        if (returnAttributes.length == 0) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute annotated in class {0} is null or empty.", this.extensionClassFullName));
        }
        if (returnAttributes.length == 1) {
            String returnAttributeName = returnAttributes[0].name();
            if (!returnAttributeName.isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name cannot be annotated in class '{0}' extended by Function Executor Processor.", this.extensionClassFullName));
            }
            if (returnAttributes[0].description().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name:{0} -> description annotated in class {1} is null or empty.", returnAttributeName, this.extensionClassFullName));
            }
            if (returnAttributes[0].type().length == 0) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name{0} -> type annotated in class {1} is null or empty.", returnAttributeName, this.extensionClassFullName));
            }
        } else {
            throw new AnnotationValidationException(MessageFormat.format("Only one @Extension -> @ReturnAttribute can be annotated in class {0}.", this.extensionClassFullName));
        }
    }
}

