/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.map;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class CreateFromXMLFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to map:createFromXML() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data instanceof String) {
            try {
                OMElement parentElement = AXIOMUtil.stringToOM((String)data.toString());
                return this.getMapFromXML(parentElement);
            }
            catch (XMLStreamException e) {
                throw new ExecutionPlanRuntimeException("Input data cannot be parsed to xml: " + e.getMessage(), (Throwable)e);
            }
        }
        throw new ExecutionPlanRuntimeException("Data should be a string");
    }

    private Object getMapFromXML(OMElement parentElement) throws XMLStreamException {
        HashMap<String, Object> topLevelMap = new HashMap<String, Object>();
        Iterator iterator = parentElement.getChildElements();
        while (iterator.hasNext()) {
            Object value;
            OMElement streamAttributeElement = (OMElement)iterator.next();
            String key = streamAttributeElement.getQName().toString();
            if (streamAttributeElement.getFirstElement() != null) {
                value = this.getMapFromXML(streamAttributeElement);
            } else {
                String elementText = streamAttributeElement.getText();
                if (elementText.equals("true") || elementText.equals("false")) {
                    value = Boolean.parseBoolean(elementText);
                } else if (NumberUtils.isNumber((String)elementText)) {
                    try {
                        value = this.numberFormat.parse(elementText);
                    }
                    catch (ParseException e) {
                        value = elementText;
                    }
                } else {
                    value = elementText;
                }
            }
            topLevelMap.put(key, value);
        }
        return topLevelMap;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

