/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.map;

import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class ToXMLFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;
    private String rootElement = null;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length > 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to map:toXML() function, required only 1 or 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors.length == 2) {
            Object rootElementObject = attributeExpressionExecutors[1].execute(null);
            if (rootElementObject instanceof String) {
                this.rootElement = (String)rootElementObject;
            } else {
                throw new OperationNotSupportedException("Root element name should be of type String. But found " + attributeExpressionExecutors[1].getReturnType());
            }
        }
    }

    protected Object execute(Object[] data) {
        if (data[0] instanceof Map) {
            Map map = (Map)data[0];
            return this.getXmlFromMapWithRootElement(map);
        }
        throw new ExecutionPlanRuntimeException("Data should be a string");
    }

    protected Object execute(Object data) {
        if (data instanceof Map) {
            Map map = (Map)data;
            return this.getXmlFromMap(map);
        }
        throw new ExecutionPlanRuntimeException("Data should be a string");
    }

    private Object getXmlFromMap(Map<Object, Object> map) {
        return this.addingElements(map);
    }

    private Object getXmlFromMapWithRootElement(Map<Object, Object> map) {
        String xmlValue = "<" + this.rootElement + ">";
        xmlValue = xmlValue + this.addingElements(map);
        xmlValue = xmlValue + "</" + this.rootElement + ">";
        return xmlValue;
    }

    private String addingElements(Map<Object, Object> map) {
        String xmlValue = "";
        for (Map.Entry<Object, Object> mapEntry : map.entrySet()) {
            xmlValue = xmlValue + "<" + mapEntry.getKey().toString() + ">";
            xmlValue = mapEntry.getValue() instanceof Map ? xmlValue + this.getXmlFromMap((Map)mapEntry.getValue()) : xmlValue + mapEntry.getValue().toString();
            xmlValue = xmlValue + "</" + mapEntry.getKey().toString() + ">";
        }
        return xmlValue;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

