/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.compiler.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.wso2.siddhi.query.api.SiddhiApp;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.FunctionDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;
import org.wso2.siddhi.query.api.definition.WindowDefinition;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.partition.PartitionType;
import org.wso2.siddhi.query.api.execution.partition.RangePartitionType;
import org.wso2.siddhi.query.api.execution.partition.ValuePartitionType;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.execution.query.input.handler.Filter;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamFunction;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamHandler;
import org.wso2.siddhi.query.api.execution.query.input.handler.Window;
import org.wso2.siddhi.query.api.execution.query.input.state.CountStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.EveryStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.NextStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.State;
import org.wso2.siddhi.query.api.execution.query.input.state.StateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.AnonymousInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.InputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.EventOutputRate;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.OutputRate;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.SnapshotOutputRate;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.TimeOutputRate;
import org.wso2.siddhi.query.api.execution.query.output.stream.DeleteStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.InsertIntoStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.ReturnStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateOrInsertStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateStream;
import org.wso2.siddhi.query.api.execution.query.selection.OutputAttribute;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.AttributeFunction;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.condition.Compare;
import org.wso2.siddhi.query.api.expression.constant.BoolConstant;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.expression.constant.DoubleConstant;
import org.wso2.siddhi.query.api.expression.constant.FloatConstant;
import org.wso2.siddhi.query.api.expression.constant.IntConstant;
import org.wso2.siddhi.query.api.expression.constant.LongConstant;
import org.wso2.siddhi.query.api.expression.constant.StringConstant;
import org.wso2.siddhi.query.api.expression.constant.TimeConstant;
import org.wso2.siddhi.query.compiler.SiddhiQLBaseVisitor;
import org.wso2.siddhi.query.compiler.SiddhiQLParser;
import org.wso2.siddhi.query.compiler.exception.SiddhiParserException;

public class SiddhiQLBaseVisitorImpl
extends SiddhiQLBaseVisitor {
    private Set<String> activeStreams = new HashSet<String>();

    @Override
    public Object visitParse(@NotNull SiddhiQLParser.ParseContext ctx) {
        return this.visit((ParseTree)ctx.siddhi_app());
    }

    @Override
    public SiddhiApp visitSiddhi_app(@NotNull SiddhiQLParser.Siddhi_appContext ctx) {
        SiddhiApp siddhiApp = SiddhiApp.siddhiApp();
        for (SiddhiQLParser.App_annotationContext annotationContext : ctx.app_annotation()) {
            siddhiApp.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        for (SiddhiQLParser.Definition_streamContext streamContext : ctx.definition_stream()) {
            siddhiApp.defineStream((StreamDefinition)this.visit((ParseTree)streamContext));
        }
        for (SiddhiQLParser.Definition_tableContext tableContext : ctx.definition_table()) {
            siddhiApp.defineTable((TableDefinition)this.visit((ParseTree)tableContext));
        }
        for (SiddhiQLParser.Definition_functionContext functionContext : ctx.definition_function()) {
            siddhiApp.defineFunction((FunctionDefinition)this.visit((ParseTree)functionContext));
        }
        for (SiddhiQLParser.Definition_windowContext windowContext : ctx.definition_window()) {
            siddhiApp.defineWindow((WindowDefinition)this.visit((ParseTree)windowContext));
        }
        for (SiddhiQLParser.Execution_elementContext executionElementContext : ctx.execution_element()) {
            ExecutionElement executionElement = (ExecutionElement)this.visit((ParseTree)executionElementContext);
            if (executionElement instanceof Partition) {
                siddhiApp.addPartition((Partition)executionElement);
                continue;
            }
            if (executionElement instanceof Query) {
                siddhiApp.addQuery((Query)executionElement);
                continue;
            }
            throw this.newSiddhiParserException(ctx);
        }
        for (SiddhiQLParser.Definition_triggerContext triggerContext : ctx.definition_trigger()) {
            siddhiApp.defineTrigger((TriggerDefinition)this.visit((ParseTree)triggerContext));
        }
        return siddhiApp;
    }

    @Override
    public Object visitDefinition_stream_final(@NotNull SiddhiQLParser.Definition_stream_finalContext ctx) {
        return this.visit((ParseTree)ctx.definition_stream());
    }

    @Override
    public StreamDefinition visitDefinition_stream(@NotNull SiddhiQLParser.Definition_streamContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        if (source.isInnerStream) {
            throw this.newSiddhiParserException(ctx, " InnerStreams cannot be defined!");
        }
        StreamDefinition streamDefinition = StreamDefinition.id((String)source.streamId);
        List<SiddhiQLParser.Attribute_nameContext> attribute_names = ctx.attribute_name();
        List<SiddhiQLParser.Attribute_typeContext> attribute_types = ctx.attribute_type();
        for (int i = 0; i < attribute_names.size(); ++i) {
            SiddhiQLParser.Attribute_nameContext attributeNameContext = attribute_names.get(i);
            SiddhiQLParser.Attribute_typeContext attributeTypeContext = attribute_types.get(i);
            streamDefinition.attribute((String)this.visit((ParseTree)attributeNameContext), (Attribute.Type)this.visit((ParseTree)attributeTypeContext));
        }
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            streamDefinition.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        return streamDefinition;
    }

    @Override
    public Object visitDefinition_function_final(@NotNull SiddhiQLParser.Definition_function_finalContext ctx) {
        return this.visit((ParseTree)ctx.definition_function());
    }

    @Override
    public FunctionDefinition visitDefinition_function(@NotNull SiddhiQLParser.Definition_functionContext ctx) {
        String functionName = (String)this.visitFunction_name(ctx.function_name());
        String languageName = (String)this.visitLanguage_name(ctx.language_name());
        Attribute.Type attributeType = (Attribute.Type)this.visit((ParseTree)ctx.attribute_type());
        String functionBody = (String)this.visitFunction_body(ctx.function_body());
        FunctionDefinition functionDefinition = new FunctionDefinition();
        functionDefinition.id(functionName).language(languageName).type(attributeType).body(functionBody);
        return functionDefinition;
    }

    @Override
    public Object visitFunction_name(@NotNull SiddhiQLParser.Function_nameContext ctx) {
        return this.visitId(ctx.id());
    }

    @Override
    public Object visitFunction_body(@NotNull SiddhiQLParser.Function_bodyContext ctx) {
        String bodyBlock = ctx.SCRIPT().getText();
        return bodyBlock.substring(1, bodyBlock.length() - 2);
    }

    @Override
    public Object visitLanguage_name(@NotNull SiddhiQLParser.Language_nameContext ctx) {
        return this.visitId(ctx.id());
    }

    @Override
    public Object visitDefinition_trigger_final(@NotNull SiddhiQLParser.Definition_trigger_finalContext ctx) {
        return this.visitDefinition_trigger(ctx.definition_trigger());
    }

    @Override
    public Object visitDefinition_trigger(@NotNull SiddhiQLParser.Definition_triggerContext ctx) {
        TriggerDefinition triggerDefinition = TriggerDefinition.id((String)((String)this.visitTrigger_name(ctx.trigger_name())));
        if (ctx.time_value() != null) {
            triggerDefinition.atEvery(this.visitTime_value(ctx.time_value()).value());
        } else {
            triggerDefinition.at(this.visitString_value(ctx.string_value()).getValue());
        }
        return triggerDefinition;
    }

    @Override
    public Object visitTrigger_name(@NotNull SiddhiQLParser.Trigger_nameContext ctx) {
        return this.visitId(ctx.id());
    }

    @Override
    public Object visitDefinition_table_final(@NotNull SiddhiQLParser.Definition_table_finalContext ctx) {
        return this.visit((ParseTree)ctx.definition_table());
    }

    @Override
    public TableDefinition visitDefinition_table(@NotNull SiddhiQLParser.Definition_tableContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        if (source.isInnerStream) {
            throw this.newSiddhiParserException(ctx, "'#' cannot be used, because Tables can't be defined as InnerStream!");
        }
        TableDefinition tableDefinition = TableDefinition.id((String)source.streamId);
        List<SiddhiQLParser.Attribute_nameContext> attribute_names = ctx.attribute_name();
        List<SiddhiQLParser.Attribute_typeContext> attribute_types = ctx.attribute_type();
        for (int i = 0; i < attribute_names.size(); ++i) {
            SiddhiQLParser.Attribute_nameContext attributeNameContext = attribute_names.get(i);
            SiddhiQLParser.Attribute_typeContext attributeTypeContext = attribute_types.get(i);
            tableDefinition.attribute((String)this.visit((ParseTree)attributeNameContext), (Attribute.Type)this.visit((ParseTree)attributeTypeContext));
        }
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            tableDefinition.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        return tableDefinition;
    }

    @Override
    public Object visitDefinition_window_final(@NotNull SiddhiQLParser.Definition_window_finalContext ctx) {
        return this.visit((ParseTree)ctx.definition_window());
    }

    @Override
    public Object visitDefinition_window(@NotNull SiddhiQLParser.Definition_windowContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        if (source.isInnerStream) {
            throw this.newSiddhiParserException(ctx, "'#' cannot be used, because Windows can't be defined as InnerStream!");
        }
        WindowDefinition windowDefinition = WindowDefinition.id((String)source.streamId);
        List<SiddhiQLParser.Attribute_nameContext> attribute_names = ctx.attribute_name();
        List<SiddhiQLParser.Attribute_typeContext> attribute_types = ctx.attribute_type();
        for (int i = 0; i < attribute_names.size(); ++i) {
            SiddhiQLParser.Attribute_nameContext attributeNameContext = attribute_names.get(i);
            SiddhiQLParser.Attribute_typeContext attributeTypeContext = attribute_types.get(i);
            windowDefinition.attribute((String)this.visit((ParseTree)attributeNameContext), (Attribute.Type)this.visit((ParseTree)attributeTypeContext));
        }
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            windowDefinition.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        AttributeFunction attributeFunction = (AttributeFunction)this.visit((ParseTree)ctx.function_operation());
        Window window = new Window(attributeFunction.getNamespace(), attributeFunction.getName(), attributeFunction.getParameters());
        windowDefinition.window(window);
        if (ctx.output_event_type() != null) {
            windowDefinition.setOutputEventType((OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()));
        }
        return windowDefinition;
    }

    @Override
    public Object visitPartition_final(@NotNull SiddhiQLParser.Partition_finalContext ctx) {
        return this.visit((ParseTree)ctx.partition());
    }

    @Override
    public Partition visitPartition(@NotNull SiddhiQLParser.PartitionContext ctx) {
        Partition partition = Partition.partition();
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            partition.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        for (SiddhiQLParser.Partition_with_streamContext with_streamContext : ctx.partition_with_stream()) {
            partition.with((PartitionType)this.visit((ParseTree)with_streamContext));
        }
        for (SiddhiQLParser.QueryContext queryContext : ctx.query()) {
            partition.addQuery((Query)this.visit((ParseTree)queryContext));
        }
        return partition;
    }

    @Override
    public PartitionType visitPartition_with_stream(@NotNull SiddhiQLParser.Partition_with_streamContext ctx) {
        String streamId = (String)this.visit((ParseTree)ctx.stream_id());
        this.activeStreams.add(streamId);
        try {
            if (ctx.condition_ranges() != null) {
                RangePartitionType rangePartitionType = new RangePartitionType(streamId, (RangePartitionType.RangePartitionProperty[])this.visit((ParseTree)ctx.condition_ranges()));
                return rangePartitionType;
            }
            if (ctx.attribute() != null) {
                ValuePartitionType valuePartitionType = new ValuePartitionType(streamId, (Expression)this.visit((ParseTree)ctx.attribute()));
                return valuePartitionType;
            }
            throw this.newSiddhiParserException(ctx);
        }
        finally {
            this.activeStreams.clear();
        }
    }

    @Override
    public RangePartitionType.RangePartitionProperty[] visitCondition_ranges(@NotNull SiddhiQLParser.Condition_rangesContext ctx) {
        RangePartitionType.RangePartitionProperty[] rangePartitionProperties = new RangePartitionType.RangePartitionProperty[ctx.condition_range().size()];
        List<SiddhiQLParser.Condition_rangeContext> condition_range = ctx.condition_range();
        for (int i = 0; i < condition_range.size(); ++i) {
            SiddhiQLParser.Condition_rangeContext rangeContext = condition_range.get(i);
            rangePartitionProperties[i] = (RangePartitionType.RangePartitionProperty)this.visit((ParseTree)rangeContext);
        }
        return rangePartitionProperties;
    }

    @Override
    public Object visitCondition_range(@NotNull SiddhiQLParser.Condition_rangeContext ctx) {
        return new RangePartitionType.RangePartitionProperty(((StringConstant)this.visit((ParseTree)ctx.string_value())).getValue(), (Expression)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public Object visitQuery_final(@NotNull SiddhiQLParser.Query_finalContext ctx) {
        return this.visit((ParseTree)ctx.query());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query visitQuery(@NotNull SiddhiQLParser.QueryContext ctx) {
        try {
            Query query = Query.query().from((InputStream)this.visit((ParseTree)ctx.query_input()));
            if (ctx.query_section() != null) {
                query.select((Selector)this.visit((ParseTree)ctx.query_section()));
            }
            if (ctx.output_rate() != null) {
                query.output((OutputRate)this.visit((ParseTree)ctx.output_rate()));
            }
            for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
                query.annotation((Annotation)this.visit((ParseTree)annotationContext));
            }
            if (ctx.query_output() != null) {
                query.outStream((OutputStream)this.visit((ParseTree)ctx.query_output()));
            }
            Query query2 = query;
            return query2;
        }
        finally {
            this.activeStreams.clear();
        }
    }

    @Override
    public Annotation visitApp_annotation(@NotNull SiddhiQLParser.App_annotationContext ctx) {
        Annotation annotation = new Annotation((String)this.visit((ParseTree)ctx.name()));
        for (SiddhiQLParser.Annotation_elementContext elementContext : ctx.annotation_element()) {
            annotation.element((Element)this.visit((ParseTree)elementContext));
        }
        return annotation;
    }

    @Override
    public Annotation visitAnnotation(@NotNull SiddhiQLParser.AnnotationContext ctx) {
        Annotation annotation = Annotation.annotation((String)((String)this.visit((ParseTree)ctx.name())));
        for (SiddhiQLParser.Annotation_elementContext elementContext : ctx.annotation_element()) {
            annotation.element((Element)this.visit((ParseTree)elementContext));
        }
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            annotation.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        return annotation;
    }

    @Override
    public Element visitAnnotation_element(@NotNull SiddhiQLParser.Annotation_elementContext ctx) {
        if (ctx.property_name() != null) {
            return new Element((String)this.visit((ParseTree)ctx.property_name()), ((StringConstant)this.visit((ParseTree)ctx.property_value())).getValue());
        }
        return new Element(null, ((StringConstant)this.visit((ParseTree)ctx.property_value())).getValue());
    }

    @Override
    public SingleInputStream visitStandard_stream(@NotNull SiddhiQLParser.Standard_streamContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        BasicSingleInputStream basicSingleInputStream = new BasicSingleInputStream(null, source.streamId, source.isInnerStream);
        if (ctx.pre_window_handlers != null) {
            basicSingleInputStream.addStreamHandlers((List)this.visit((ParseTree)ctx.pre_window_handlers));
        }
        if (ctx.window() == null && ctx.post_window_handlers == null) {
            return basicSingleInputStream;
        }
        if (ctx.window() != null) {
            SingleInputStream singleInputStream = new SingleInputStream(basicSingleInputStream, (Window)this.visit((ParseTree)ctx.window()));
            if (ctx.post_window_handlers != null) {
                singleInputStream.addStreamHandlers((List)this.visit((ParseTree)ctx.post_window_handlers));
            }
            return singleInputStream;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitJoin_stream(@NotNull SiddhiQLParser.Join_streamContext ctx) {
        SingleInputStream leftStream = (SingleInputStream)this.visit((ParseTree)ctx.left_source);
        SingleInputStream rightStream = (SingleInputStream)this.visit((ParseTree)ctx.right_source);
        JoinInputStream.Type joinType = (JoinInputStream.Type)this.visit((ParseTree)ctx.join());
        TimeConstant timeConstant = null;
        Expression onCondition = null;
        JoinInputStream.EventTrigger eventTrigger = null;
        if (ctx.within_time() != null) {
            timeConstant = (TimeConstant)this.visit((ParseTree)ctx.within_time());
        }
        if (ctx.expression() != null) {
            onCondition = (Expression)this.visit((ParseTree)ctx.expression());
        }
        eventTrigger = ctx.right_unidirectional != null ? JoinInputStream.EventTrigger.RIGHT : (ctx.left_unidirectional != null ? JoinInputStream.EventTrigger.LEFT : JoinInputStream.EventTrigger.ALL);
        return InputStream.joinStream((SingleInputStream)leftStream, (JoinInputStream.Type)joinType, (SingleInputStream)rightStream, (Expression)onCondition, (Constant)timeConstant, (JoinInputStream.EventTrigger)eventTrigger);
    }

    @Override
    public Object visitJoin_source(@NotNull SiddhiQLParser.Join_sourceContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        String streamAlias = null;
        if (ctx.stream_alias() != null) {
            streamAlias = (String)this.visit((ParseTree)ctx.stream_alias());
            this.activeStreams.remove(ctx.source().getText());
            this.activeStreams.add(streamAlias);
        }
        BasicSingleInputStream basicSingleInputStream = new BasicSingleInputStream(streamAlias, source.streamId, source.isInnerStream);
        if (ctx.basic_source_stream_handlers() != null) {
            basicSingleInputStream.addStreamHandlers((List)this.visit((ParseTree)ctx.basic_source_stream_handlers()));
        }
        if (ctx.window() != null) {
            return new SingleInputStream(basicSingleInputStream, (Window)this.visit((ParseTree)ctx.window()));
        }
        return basicSingleInputStream;
    }

    @Override
    public Object visitPattern_stream(@NotNull SiddhiQLParser.Pattern_streamContext ctx) {
        StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.every_pattern_source_chain());
        return new StateInputStream(StateInputStream.Type.PATTERN, stateElement);
    }

    @Override
    public Object visitEvery_pattern_source_chain(@NotNull SiddhiQLParser.Every_pattern_source_chainContext ctx) {
        if (ctx.every_pattern_source_chain().size() == 1) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.every_pattern_source_chain(0));
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            return stateElement;
        }
        if (ctx.every_pattern_source_chain().size() == 2) {
            return new NextStateElement((StateElement)this.visit((ParseTree)ctx.every_pattern_source_chain(0)), (StateElement)this.visit((ParseTree)ctx.every_pattern_source_chain(1)));
        }
        if (ctx.EVERY() != null) {
            if (ctx.pattern_source_chain() != null) {
                EveryStateElement everyStateElement = new EveryStateElement((StateElement)this.visit((ParseTree)ctx.pattern_source_chain()));
                if (ctx.within_time() != null) {
                    everyStateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
                }
                return everyStateElement;
            }
            if (ctx.pattern_source() != null) {
                EveryStateElement everyStateElement = new EveryStateElement((StateElement)this.visit((ParseTree)ctx.pattern_source()));
                if (ctx.within_time() != null) {
                    everyStateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
                }
                return everyStateElement;
            }
            throw this.newSiddhiParserException(ctx);
        }
        if (ctx.pattern_source_chain() != null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.pattern_source_chain());
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            return stateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitPattern_source_chain(@NotNull SiddhiQLParser.Pattern_source_chainContext ctx) {
        if (ctx.pattern_source_chain().size() == 1) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.pattern_source_chain(0));
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            return stateElement;
        }
        if (ctx.pattern_source_chain().size() == 2) {
            return new NextStateElement((StateElement)this.visit((ParseTree)ctx.pattern_source_chain(0)), (StateElement)this.visit((ParseTree)ctx.pattern_source_chain(1)));
        }
        if (ctx.pattern_source() != null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.pattern_source());
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            return stateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitLogical_stateful_source(@NotNull SiddhiQLParser.Logical_stateful_sourceContext ctx) {
        if (ctx.NOT() != null) {
            if (ctx.AND() != null) {
                StreamStateElement streamStateElement1 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(0));
                StreamStateElement streamStateElement2 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(1));
                return State.logicalNotAnd((StreamStateElement)streamStateElement1, (StreamStateElement)streamStateElement2);
            }
            BasicSingleInputStream basicSingleInputStream = (BasicSingleInputStream)this.visit((ParseTree)ctx.standard_stateful_source(0));
            return State.logicalNot((StreamStateElement)new StreamStateElement(basicSingleInputStream), null);
        }
        if (ctx.AND() != null) {
            StreamStateElement streamStateElement1 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(0));
            StreamStateElement streamStateElement2 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(1));
            return State.logicalAnd((StreamStateElement)streamStateElement1, (StreamStateElement)streamStateElement2);
        }
        if (ctx.OR() != null) {
            StreamStateElement streamStateElement1 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(0));
            StreamStateElement streamStateElement2 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(1));
            return State.logicalOr((StreamStateElement)streamStateElement1, (StreamStateElement)streamStateElement2);
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public CountStateElement visitPattern_collection_stateful_source(@NotNull SiddhiQLParser.Pattern_collection_stateful_sourceContext ctx) {
        StreamStateElement streamStateElement = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source());
        if (ctx.collect() != null) {
            Object[] minMax = (Object[])this.visit((ParseTree)ctx.collect());
            int min = -1;
            int max = -1;
            if (minMax[0] != null) {
                min = (Integer)minMax[0];
            }
            if (minMax[1] != null) {
                max = (Integer)minMax[1];
            }
            return new CountStateElement(streamStateElement, min, max);
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public StateInputStream visitSequence_stream(@NotNull SiddhiQLParser.Sequence_streamContext ctx) {
        Object stateElement1 = ctx.EVERY() != null ? new EveryStateElement((StateElement)this.visit((ParseTree)ctx.sequence_source())) : (StateElement)this.visit((ParseTree)ctx.sequence_source());
        if (ctx.within_time() != null) {
            stateElement1.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
        }
        return new StateInputStream(StateInputStream.Type.SEQUENCE, (StateElement)new NextStateElement(stateElement1, (StateElement)this.visit((ParseTree)ctx.sequence_source_chain())));
    }

    @Override
    public StateElement visitSequence_source_chain(@NotNull SiddhiQLParser.Sequence_source_chainContext ctx) {
        if (ctx.sequence_source_chain().size() == 1) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.sequence_source_chain(0));
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            return stateElement;
        }
        if (ctx.sequence_source_chain().size() == 2) {
            return new NextStateElement((StateElement)this.visit((ParseTree)ctx.sequence_source_chain(0)), (StateElement)this.visit((ParseTree)ctx.sequence_source_chain(1)));
        }
        if (ctx.sequence_source() != null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.sequence_source());
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            return stateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public BasicSingleInputStream visitBasic_source(@NotNull SiddhiQLParser.Basic_sourceContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        BasicSingleInputStream basicSingleInputStream = new BasicSingleInputStream(null, source.streamId, source.isInnerStream);
        if (ctx.basic_source_stream_handlers() != null) {
            basicSingleInputStream.addStreamHandlers((List)this.visit((ParseTree)ctx.basic_source_stream_handlers()));
        }
        return basicSingleInputStream;
    }

    @Override
    public List<StreamHandler> visitBasic_source_stream_handlers(@NotNull SiddhiQLParser.Basic_source_stream_handlersContext ctx) {
        ArrayList<StreamHandler> streamHandlers = new ArrayList<StreamHandler>();
        for (SiddhiQLParser.Basic_source_stream_handlerContext handlerContext : ctx.basic_source_stream_handler()) {
            streamHandlers.add((StreamHandler)this.visit((ParseTree)handlerContext));
        }
        return streamHandlers;
    }

    @Override
    public String visitEvent(@NotNull SiddhiQLParser.EventContext ctx) {
        return ctx.getText();
    }

    @Override
    public StreamStateElement visitStandard_stateful_source(@NotNull SiddhiQLParser.Standard_stateful_sourceContext ctx) {
        if (ctx.event() != null) {
            this.activeStreams.add(this.visitEvent(ctx.event()));
        }
        BasicSingleInputStream basicSingleInputStream = (BasicSingleInputStream)this.visit((ParseTree)ctx.basic_source());
        if (ctx.event() != null) {
            if (basicSingleInputStream.isInnerStream()) {
                this.activeStreams.remove("#" + basicSingleInputStream.getStreamId());
            } else {
                this.activeStreams.remove(basicSingleInputStream.getStreamId());
            }
            return new StreamStateElement(basicSingleInputStream.as((String)this.visit((ParseTree)ctx.event())));
        }
        return new StreamStateElement(basicSingleInputStream);
    }

    @Override
    public CountStateElement visitSequence_collection_stateful_source(@NotNull SiddhiQLParser.Sequence_collection_stateful_sourceContext ctx) {
        StreamStateElement streamStateElement = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source());
        if (ctx.one_or_more != null) {
            return new CountStateElement(streamStateElement, 1, -1);
        }
        if (ctx.zero_or_more != null) {
            return new CountStateElement(streamStateElement, 0, -1);
        }
        if (ctx.zero_or_one != null) {
            return new CountStateElement(streamStateElement, 0, 1);
        }
        if (ctx.collect() != null) {
            Object[] minMax = (Object[])this.visit((ParseTree)ctx.collect());
            int min = -1;
            int max = -1;
            if (minMax[0] != null) {
                min = (Integer)minMax[0];
            }
            if (minMax[1] != null) {
                max = (Integer)minMax[1];
            }
            return new CountStateElement(streamStateElement, min, max);
        }
        throw this.newSiddhiParserException(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnonymousInputStream visitAnonymous_stream(@NotNull SiddhiQLParser.Anonymous_streamContext ctx) {
        if (ctx.anonymous_stream() != null) {
            return (AnonymousInputStream)this.visit((ParseTree)ctx.anonymous_stream());
        }
        Set<String> activeStreamsBackup = this.activeStreams;
        try {
            this.activeStreams = new HashSet<String>();
            Query query = Query.query().from((InputStream)this.visit((ParseTree)ctx.query_input()));
            if (ctx.query_section() != null) {
                query.select((Selector)this.visit((ParseTree)ctx.query_section()));
            }
            if (ctx.output_rate() != null) {
                query.output((OutputRate)this.visit((ParseTree)ctx.output_rate()));
            }
            if (ctx.output_event_type() != null) {
                query.outStream((OutputStream)new ReturnStream((OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type())));
            } else {
                query.outStream((OutputStream)new ReturnStream());
            }
            AnonymousInputStream anonymousInputStream = new AnonymousInputStream(query);
            return anonymousInputStream;
        }
        finally {
            this.activeStreams.clear();
            this.activeStreams = activeStreamsBackup;
        }
    }

    @Override
    public Filter visitFilter(@NotNull SiddhiQLParser.FilterContext ctx) {
        return new Filter((Expression)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public StreamFunction visitStream_function(@NotNull SiddhiQLParser.Stream_functionContext ctx) {
        AttributeFunction attributeFunction = (AttributeFunction)this.visit((ParseTree)ctx.function_operation());
        return new StreamFunction(attributeFunction.getNamespace(), attributeFunction.getName(), attributeFunction.getParameters());
    }

    @Override
    public Window visitWindow(@NotNull SiddhiQLParser.WindowContext ctx) {
        AttributeFunction attributeFunction = (AttributeFunction)this.visit((ParseTree)ctx.function_operation());
        return new Window(attributeFunction.getNamespace(), attributeFunction.getName(), attributeFunction.getParameters());
    }

    @Override
    public Selector visitQuery_section(@NotNull SiddhiQLParser.Query_sectionContext ctx) {
        Selector selector = new Selector();
        ArrayList<OutputAttribute> attributeList = new ArrayList<OutputAttribute>(ctx.output_attribute().size());
        for (SiddhiQLParser.Output_attributeContext output_attributeContext : ctx.output_attribute()) {
            attributeList.add((OutputAttribute)this.visit((ParseTree)output_attributeContext));
        }
        selector.addSelectionList(attributeList);
        if (ctx.group_by() != null) {
            selector.addGroupByList((List)this.visit((ParseTree)ctx.group_by()));
        }
        if (ctx.having() != null) {
            selector.having((Expression)this.visit((ParseTree)ctx.having()));
        }
        return selector;
    }

    @Override
    public List<Variable> visitGroup_by(@NotNull SiddhiQLParser.Group_byContext ctx) {
        ArrayList<Variable> variableList = new ArrayList<Variable>(ctx.attribute_reference().size());
        for (SiddhiQLParser.Attribute_referenceContext attributeReferenceContext : ctx.attribute_reference()) {
            variableList.add((Variable)this.visit((ParseTree)attributeReferenceContext));
        }
        return variableList;
    }

    @Override
    public Expression visitHaving(@NotNull SiddhiQLParser.HavingContext ctx) {
        return (Expression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public OutputStream visitQuery_output(@NotNull SiddhiQLParser.Query_outputContext ctx) {
        if (ctx.INSERT() != null) {
            Source source = (Source)this.visit((ParseTree)ctx.target());
            if (ctx.UPDATE() != null && ctx.OR() != null) {
                if (source.isInnerStream) {
                    throw this.newSiddhiParserException(ctx, "UPDATE OR INTO INSERT be only used with Tables!");
                }
                if (ctx.output_event_type() != null) {
                    return new UpdateOrInsertStream(source.streamId, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()), (Expression)this.visit((ParseTree)ctx.expression()));
                }
                return new UpdateOrInsertStream(source.streamId, (Expression)this.visit((ParseTree)ctx.expression()));
            }
            if (ctx.output_event_type() != null) {
                return new InsertIntoStream(source.streamId, source.isInnerStream, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()));
            }
            return new InsertIntoStream(source.streamId, source.isInnerStream);
        }
        if (ctx.DELETE() != null) {
            Source source = (Source)this.visit((ParseTree)ctx.target());
            if (source.isInnerStream) {
                throw this.newSiddhiParserException(ctx, "DELETE can be only used with Tables!");
            }
            if (ctx.output_event_type() != null) {
                return new DeleteStream(source.streamId, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()), (Expression)this.visit((ParseTree)ctx.expression()));
            }
            return new DeleteStream(source.streamId, (Expression)this.visit((ParseTree)ctx.expression()));
        }
        if (ctx.UPDATE() != null) {
            Source source = (Source)this.visit((ParseTree)ctx.target());
            if (source.isInnerStream) {
                throw this.newSiddhiParserException(ctx, "DELETE can be only used with Tables!");
            }
            if (ctx.output_event_type() != null) {
                return new UpdateStream(source.streamId, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()), (Expression)this.visit((ParseTree)ctx.expression()));
            }
            return new UpdateStream(source.streamId, (Expression)this.visit((ParseTree)ctx.expression()));
        }
        if (ctx.RETURN() != null) {
            if (ctx.output_event_type() != null) {
                return new ReturnStream((OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()));
            }
            return new ReturnStream();
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public OutputStream.OutputEventType visitOutput_event_type(@NotNull SiddhiQLParser.Output_event_typeContext ctx) {
        if (ctx.ALL() != null) {
            if (ctx.RAW() != null) {
                return OutputStream.OutputEventType.ALL_RAW_EVENTS;
            }
            return OutputStream.OutputEventType.ALL_EVENTS;
        }
        if (ctx.EXPIRED() != null) {
            if (ctx.RAW() != null) {
                return OutputStream.OutputEventType.EXPIRED_RAW_EVENTS;
            }
            return OutputStream.OutputEventType.EXPIRED_EVENTS;
        }
        return OutputStream.OutputEventType.CURRENT_EVENTS;
    }

    @Override
    public OutputRate visitOutput_rate(@NotNull SiddhiQLParser.Output_rateContext ctx) {
        if (ctx.SNAPSHOT() != null) {
            return new SnapshotOutputRate(Long.valueOf(((TimeConstant)this.visit((ParseTree)ctx.time_value())).value()));
        }
        if (ctx.time_value() != null) {
            TimeOutputRate timeOutputRate = new TimeOutputRate(Long.valueOf(((TimeConstant)this.visit((ParseTree)ctx.time_value())).value()));
            if (ctx.output_rate_type() != null) {
                timeOutputRate.output((OutputRate.Type)this.visit((ParseTree)ctx.output_rate_type()));
            }
            return timeOutputRate;
        }
        if (ctx.EVENTS() != null) {
            EventOutputRate eventOutputRate = new EventOutputRate(Integer.valueOf(Integer.parseInt(ctx.INT_LITERAL().getText())));
            if (ctx.output_rate_type() != null) {
                eventOutputRate.output((OutputRate.Type)this.visit((ParseTree)ctx.output_rate_type()));
            }
            return eventOutputRate;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitOutput_rate_type(@NotNull SiddhiQLParser.Output_rate_typeContext ctx) {
        if (ctx.ALL() != null) {
            return OutputRate.Type.ALL;
        }
        if (ctx.LAST() != null) {
            return OutputRate.Type.LAST;
        }
        if (ctx.FIRST() != null) {
            return OutputRate.Type.FIRST;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitOutput_attribute(@NotNull SiddhiQLParser.Output_attributeContext ctx) {
        if (ctx.AS() != null) {
            return new OutputAttribute((String)this.visit((ParseTree)ctx.attribute_name()), (Expression)this.visit((ParseTree)ctx.attribute()));
        }
        return new OutputAttribute((Variable)this.visit((ParseTree)ctx.attribute_reference()));
    }

    @Override
    public Object visitOr_math_operation(@NotNull SiddhiQLParser.Or_math_operationContext ctx) {
        if (ctx.OR() != null) {
            return Expression.or((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Expression visitAnd_math_operation(@NotNull SiddhiQLParser.And_math_operationContext ctx) {
        if (ctx.AND() != null) {
            return Expression.and((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Expression visitEquality_math_operation(@NotNull SiddhiQLParser.Equality_math_operationContext ctx) {
        if (ctx.eq != null) {
            return Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.EQUAL, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        if (ctx.not_eq != null) {
            return Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.NOT_EQUAL, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Expression visitGreaterthan_lessthan_math_operation(@NotNull SiddhiQLParser.Greaterthan_lessthan_math_operationContext ctx) {
        if (ctx.gt != null) {
            return Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.GREATER_THAN, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        if (ctx.lt != null) {
            return Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.LESS_THAN, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        if (ctx.gt_eq != null) {
            return Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        if (ctx.lt_eq != null) {
            return Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.LESS_THAN_EQUAL, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Expression visitAddition_math_operation(@NotNull SiddhiQLParser.Addition_math_operationContext ctx) {
        if (ctx.add != null) {
            return Expression.add((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        if (ctx.substract != null) {
            return Expression.subtract((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Expression visitMultiplication_math_operation(@NotNull SiddhiQLParser.Multiplication_math_operationContext ctx) {
        if (ctx.multiply != null) {
            return Expression.multiply((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        if (ctx.devide != null) {
            return Expression.divide((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        if (ctx.mod != null) {
            return Expression.mod((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Expression visitNot_math_operation(@NotNull SiddhiQLParser.Not_math_operationContext ctx) {
        return Expression.not((Expression)((Expression)this.visit((ParseTree)ctx.math_operation())));
    }

    @Override
    public Object visitIn_math_operation(@NotNull SiddhiQLParser.In_math_operationContext ctx) {
        return Expression.in((Expression)((Expression)this.visit((ParseTree)ctx.math_operation())), (String)((String)this.visit((ParseTree)ctx.name())));
    }

    @Override
    public Object visitBasic_math_operation(@NotNull SiddhiQLParser.Basic_math_operationContext ctx) {
        if (ctx.math_operation() != null) {
            return this.visit((ParseTree)ctx.math_operation());
        }
        if (ctx.attribute_reference() != null) {
            return this.visit((ParseTree)ctx.attribute_reference());
        }
        if (ctx.constant_value() != null) {
            return this.visit((ParseTree)ctx.constant_value());
        }
        if (ctx.null_check() != null) {
            return this.visit((ParseTree)ctx.null_check());
        }
        if (ctx.function_operation() != null) {
            return this.visit((ParseTree)ctx.function_operation());
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitFunction_operation(@NotNull SiddhiQLParser.Function_operationContext ctx) {
        if (ctx.function_namespace() != null) {
            if (ctx.attribute_list() != null) {
                return Expression.function((String)((String)this.visit((ParseTree)ctx.function_namespace())), (String)((String)this.visit((ParseTree)ctx.function_id())), (Expression[])((Expression[])this.visit((ParseTree)ctx.attribute_list())));
            }
            return Expression.function((String)((String)this.visit((ParseTree)ctx.function_namespace())), (String)((String)this.visit((ParseTree)ctx.function_id())), null);
        }
        if (ctx.attribute_list() != null) {
            return Expression.function((String)((String)this.visit((ParseTree)ctx.function_id())), (Expression[])((Expression[])this.visit((ParseTree)ctx.attribute_list())));
        }
        return Expression.function((String)((String)this.visit((ParseTree)ctx.function_id())), null);
    }

    @Override
    public Object visitAttribute_list(@NotNull SiddhiQLParser.Attribute_listContext ctx) {
        Expression[] expressionArray = new Expression[ctx.attribute().size()];
        List<SiddhiQLParser.AttributeContext> attribute = ctx.attribute();
        for (int i = 0; i < attribute.size(); ++i) {
            SiddhiQLParser.AttributeContext attributeContext = attribute.get(i);
            expressionArray[i] = (Expression)this.visit((ParseTree)attributeContext);
        }
        return expressionArray;
    }

    @Override
    public Object visitNull_check(@NotNull SiddhiQLParser.Null_checkContext ctx) {
        if (ctx.stream_reference() != null) {
            StreamReference streamReference = (StreamReference)this.visit((ParseTree)ctx.stream_reference());
            if (streamReference.isInnerStream) {
                if (streamReference.streamIndex != null) {
                    return Expression.isNullInnerStream((String)streamReference.streamId, (int)streamReference.streamIndex);
                }
                return Expression.isNullInnerStream((String)streamReference.streamId);
            }
            if (this.activeStreams.contains(streamReference.streamId)) {
                if (streamReference.streamIndex != null) {
                    return Expression.isNullStream((String)streamReference.streamId, (int)streamReference.streamIndex);
                }
                return Expression.isNullStream((String)streamReference.streamId);
            }
            return Expression.isNull((Expression)Expression.variable((String)streamReference.streamId));
        }
        if (ctx.function_operation() != null) {
            return Expression.isNull((Expression)((Expression)this.visit((ParseTree)ctx.function_operation())));
        }
        return Expression.isNull((Expression)((Expression)this.visit((ParseTree)ctx.attribute_reference())));
    }

    @Override
    public Object visitStream_reference(@NotNull SiddhiQLParser.Stream_referenceContext ctx) {
        StreamReference streamReference = new StreamReference();
        if (ctx.hash != null) {
            streamReference.isInnerStream = true;
        }
        streamReference.streamId = (String)this.visit((ParseTree)ctx.name());
        if (ctx.attribute_index() != null) {
            streamReference.streamIndex = (Integer)this.visit((ParseTree)ctx.attribute_index());
        }
        return streamReference;
    }

    @Override
    public Variable visitAttribute_reference(@NotNull SiddhiQLParser.Attribute_referenceContext ctx) {
        Variable variable = Expression.variable((String)((String)this.visit((ParseTree)ctx.attribute_name())));
        if (ctx.name1 != null && ctx.name2 != null) {
            variable.setStreamId(ctx.hash1 != null, (String)this.visit((ParseTree)ctx.name1));
            if (ctx.attribute_index1 != null) {
                variable.setStreamIndex((Integer)this.visit((ParseTree)ctx.attribute_index1));
            }
            variable.setFunctionId((String)this.visit((ParseTree)ctx.name2));
            if (ctx.attribute_index2 != null) {
                variable.setFunctionIndex((Integer)this.visit((ParseTree)ctx.attribute_index2));
            }
        } else if (ctx.name1 != null) {
            if (ctx.hash1 == null) {
                variable.setStreamId((String)this.visit((ParseTree)ctx.name1));
                if (ctx.attribute_index1 != null) {
                    variable.setStreamIndex((Integer)this.visit((ParseTree)ctx.attribute_index1));
                }
            } else {
                String name = (String)this.visit((ParseTree)ctx.name1);
                if (this.activeStreams.contains("#" + name)) {
                    variable.setStreamId(true, name);
                    if (ctx.attribute_index1 != null) {
                        variable.setStreamIndex((Integer)this.visit((ParseTree)ctx.attribute_index1));
                    }
                } else {
                    variable.setFunctionId(name);
                    if (ctx.attribute_index1 != null) {
                        variable.setFunctionIndex((Integer)this.visit((ParseTree)ctx.attribute_index1));
                    }
                }
            }
        }
        return variable;
    }

    @Override
    public Integer visitAttribute_index(@NotNull SiddhiQLParser.Attribute_indexContext ctx) {
        int index;
        if (ctx.LAST() != null) {
            index = -2;
            if (ctx.INT_LITERAL() != null) {
                index -= Integer.parseInt(ctx.INT_LITERAL().getText());
            }
        } else {
            index = Integer.parseInt(ctx.INT_LITERAL().getText());
        }
        return index;
    }

    @Override
    public Object visitProperty_name(@NotNull SiddhiQLParser.Property_nameContext ctx) {
        StringBuilder stringBuilder = new StringBuilder();
        List<SiddhiQLParser.NameContext> propertyNameList = ctx.name();
        List<SiddhiQLParser.Property_separatorContext> propertySeparator = ctx.property_separator();
        for (int i = 0; i < propertyNameList.size(); ++i) {
            stringBuilder.append(this.visit((ParseTree)propertyNameList.get(i)));
            if (i >= propertySeparator.size()) continue;
            stringBuilder.append(propertySeparator.get(i).getText());
        }
        return stringBuilder.toString();
    }

    @Override
    public Source visitSource(@NotNull SiddhiQLParser.SourceContext ctx) {
        Source source = new Source();
        source.streamId = (String)this.visit((ParseTree)ctx.stream_id());
        source.isInnerStream = ctx.inner != null;
        this.activeStreams.add(ctx.getText());
        return source;
    }

    @Override
    public Object visitName(@NotNull SiddhiQLParser.NameContext ctx) {
        if (ctx.id() != null) {
            return this.visit((ParseTree)ctx.id());
        }
        if (ctx.keyword() != null) {
            return this.visit((ParseTree)ctx.keyword());
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object[] visitCollect(@NotNull SiddhiQLParser.CollectContext ctx) {
        Object[] minMax = new Object[2];
        if (ctx.start == null && ctx.end == null) {
            Integer value = Integer.parseInt(ctx.INT_LITERAL(0).getText());
            minMax[0] = value;
            minMax[1] = value;
        } else {
            if (ctx.start != null) {
                minMax[0] = Integer.parseInt(ctx.start.getText());
            }
            if (ctx.end != null) {
                minMax[1] = Integer.parseInt(ctx.end.getText());
            }
        }
        return minMax;
    }

    @Override
    public Object visitAttribute_type(@NotNull SiddhiQLParser.Attribute_typeContext ctx) {
        if (ctx.STRING() != null) {
            return Attribute.Type.STRING;
        }
        if (ctx.INT() != null) {
            return Attribute.Type.INT;
        }
        if (ctx.LONG() != null) {
            return Attribute.Type.LONG;
        }
        if (ctx.FLOAT() != null) {
            return Attribute.Type.FLOAT;
        }
        if (ctx.DOUBLE() != null) {
            return Attribute.Type.DOUBLE;
        }
        if (ctx.BOOL() != null) {
            return Attribute.Type.BOOL;
        }
        if (ctx.OBJECT() != null) {
            return Attribute.Type.OBJECT;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public JoinInputStream.Type visitJoin(@NotNull SiddhiQLParser.JoinContext ctx) {
        if (ctx.OUTER() != null) {
            if (ctx.FULL() != null) {
                return JoinInputStream.Type.FULL_OUTER_JOIN;
            }
            if (ctx.RIGHT() != null) {
                return JoinInputStream.Type.RIGHT_OUTER_JOIN;
            }
            if (ctx.LEFT() != null) {
                return JoinInputStream.Type.LEFT_OUTER_JOIN;
            }
            throw this.newSiddhiParserException(ctx, "Found " + ctx.getText() + " but only FULL OUTER JOIN, RIGHT " + "OUTER JOIN, LEFT OUTER JOIN are supported!");
        }
        return JoinInputStream.Type.JOIN;
    }

    @Override
    public Constant visitConstant_value(@NotNull SiddhiQLParser.Constant_valueContext ctx) {
        if (ctx.bool_value() != null) {
            return Expression.value((boolean)((BoolConstant)this.visit((ParseTree)ctx.bool_value())).getValue());
        }
        if (ctx.signed_double_value() != null) {
            return Expression.value((double)((DoubleConstant)this.visit((ParseTree)ctx.signed_double_value())).getValue());
        }
        if (ctx.signed_float_value() != null) {
            return Expression.value((float)((FloatConstant)this.visit((ParseTree)ctx.signed_float_value())).getValue().floatValue());
        }
        if (ctx.signed_long_value() != null) {
            return Expression.value((long)((LongConstant)this.visit((ParseTree)ctx.signed_long_value())).getValue());
        }
        if (ctx.signed_int_value() != null) {
            return Expression.value((int)((IntConstant)this.visit((ParseTree)ctx.signed_int_value())).getValue());
        }
        if (ctx.time_value() != null) {
            return (TimeConstant)this.visit((ParseTree)ctx.time_value());
        }
        if (ctx.string_value() != null) {
            return Expression.value((String)((StringConstant)this.visit((ParseTree)ctx.string_value())).getValue());
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public String visitId(@NotNull SiddhiQLParser.IdContext ctx) {
        return ctx.getText();
    }

    @Override
    public Object visitKeyword(@NotNull SiddhiQLParser.KeywordContext ctx) {
        return ctx.getText();
    }

    @Override
    public TimeConstant visitTime_value(@NotNull SiddhiQLParser.Time_valueContext ctx) {
        TimeConstant timeValueInMillis = Expression.Time.milliSec((int)0);
        if (ctx.millisecond_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.millisecond_value())).value());
        }
        if (ctx.second_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.second_value())).value());
        }
        if (ctx.minute_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.minute_value())).value());
        }
        if (ctx.hour_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.hour_value())).value());
        }
        if (ctx.day_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.day_value())).value());
        }
        if (ctx.week_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.week_value())).value());
        }
        if (ctx.month_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.month_value())).value());
        }
        if (ctx.year_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.year_value())).value());
        }
        return timeValueInMillis;
    }

    @Override
    public TimeConstant visitYear_value(@NotNull SiddhiQLParser.Year_valueContext ctx) {
        return Expression.Time.year((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
    }

    @Override
    public TimeConstant visitMonth_value(@NotNull SiddhiQLParser.Month_valueContext ctx) {
        return Expression.Time.month((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
    }

    @Override
    public TimeConstant visitWeek_value(@NotNull SiddhiQLParser.Week_valueContext ctx) {
        return Expression.Time.week((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
    }

    @Override
    public TimeConstant visitDay_value(@NotNull SiddhiQLParser.Day_valueContext ctx) {
        return Expression.Time.day((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
    }

    @Override
    public TimeConstant visitHour_value(@NotNull SiddhiQLParser.Hour_valueContext ctx) {
        return Expression.Time.hour((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
    }

    @Override
    public TimeConstant visitMinute_value(@NotNull SiddhiQLParser.Minute_valueContext ctx) {
        return Expression.Time.minute((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
    }

    @Override
    public TimeConstant visitSecond_value(@NotNull SiddhiQLParser.Second_valueContext ctx) {
        return Expression.Time.sec((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
    }

    @Override
    public TimeConstant visitMillisecond_value(@NotNull SiddhiQLParser.Millisecond_valueContext ctx) {
        return Expression.Time.milliSec((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
    }

    @Override
    public DoubleConstant visitSigned_double_value(@NotNull SiddhiQLParser.Signed_double_valueContext ctx) {
        return Expression.value((double)Double.parseDouble(ctx.getText()));
    }

    @Override
    public LongConstant visitSigned_long_value(@NotNull SiddhiQLParser.Signed_long_valueContext ctx) {
        return Expression.value((long)Long.parseLong(ctx.getText().replaceFirst("[lL]", "")));
    }

    @Override
    public FloatConstant visitSigned_float_value(@NotNull SiddhiQLParser.Signed_float_valueContext ctx) {
        return Expression.value((float)Float.parseFloat(ctx.getText()));
    }

    @Override
    public IntConstant visitSigned_int_value(@NotNull SiddhiQLParser.Signed_int_valueContext ctx) {
        return Expression.value((int)Integer.parseInt(ctx.getText()));
    }

    @Override
    public BoolConstant visitBool_value(@NotNull SiddhiQLParser.Bool_valueContext ctx) {
        return Expression.value((boolean)"true".equalsIgnoreCase(ctx.getText()));
    }

    @Override
    public StringConstant visitString_value(@NotNull SiddhiQLParser.String_valueContext ctx) {
        return Expression.value((String)ctx.STRING_LITERAL().getText());
    }

    public SiddhiParserException newSiddhiParserException(ParserRuleContext context) {
        return new SiddhiParserException("You have an error in your SiddhiQL near '" + context.getText() + "'  line " + context.start.getLine() + ":" + context.start.getCharPositionInLine());
    }

    public SiddhiParserException newSiddhiParserException(ParserRuleContext context, String message) {
        return new SiddhiParserException("You have an error in your SiddhiQL near '" + context.getText() + "'  line " + context.start.getLine() + ":" + context.start.getCharPositionInLine() + ", " + message);
    }

    private static class StreamReference {
        private String streamId;
        private boolean isInnerStream;
        private Integer streamIndex;

        private StreamReference() {
        }
    }

    private static class Source {
        private String streamId;
        private boolean isInnerStream;

        private Source() {
        }
    }
}

