/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.yatech.jedis.collections.JedisCallable;
import org.yatech.jedis.collections.JedisCollectionBase;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisMap
extends JedisCollectionBase
implements Map<String, String> {
    JedisMap(JedisPool jedisPool, int db, String key) {
        super(jedisPool, db, key);
    }

    JedisMap(Jedis jedis, String key) {
        super(jedis, key);
    }

    @Override
    public int size() {
        long length = this.length();
        return Integer.valueOf("" + length);
    }

    public long length() {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.exists(JedisMap.this.getKey()) != false ? jedis.hlen(JedisMap.this.getKey()) : 0L;
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0L;
    }

    @Override
    public boolean containsKey(final Object field) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                return jedis.exists(JedisMap.this.getKey()) != false ? jedis.hexists(JedisMap.this.getKey(), field.toString()) : false;
            }
        });
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value.toString());
    }

    @Override
    public String get(final Object field) {
        return this.doWithJedis(new JedisCallable<String>(){

            @Override
            public String call(Jedis jedis) {
                return jedis.exists(JedisMap.this.getKey()) != false ? jedis.hget(JedisMap.this.getKey(), field.toString()) : null;
            }
        });
    }

    @Override
    public String put(final String field, final String value) {
        return this.doWithJedis(new JedisCallable<String>(){

            @Override
            public String call(Jedis jedis) {
                String oldValue = jedis.exists(JedisMap.this.getKey()) != false ? jedis.hget(JedisMap.this.getKey(), field) : null;
                jedis.hset(JedisMap.this.getKey(), field, value);
                return oldValue;
            }
        });
    }

    public boolean putIfMissing(final String field, final String value) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                return jedis.hsetnx(JedisMap.this.getKey(), field, value) != 0L;
            }
        });
    }

    @Override
    public String remove(final Object field) {
        return this.doWithJedis(new JedisCallable<String>(){

            @Override
            public String call(Jedis jedis) {
                String oldValue = jedis.exists(JedisMap.this.getKey()) != false ? jedis.hget(JedisMap.this.getKey(), field.toString()) : null;
                jedis.hdel(JedisMap.this.getKey(), new String[]{field.toString()});
                return oldValue;
            }
        });
    }

    public long remove(final String ... fields) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.hdel(JedisMap.this.getKey(), fields);
            }
        });
    }

    @Override
    public void putAll(final Map<? extends String, ? extends String> hash) {
        this.doWithJedis(new JedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) {
                jedis.hmset(JedisMap.this.getKey(), hash);
                return null;
            }
        });
    }

    @Override
    public void clear() {
        this.doWithJedis(new JedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) {
                jedis.del(JedisMap.this.getKey());
                return null;
            }
        });
    }

    @Override
    public Set<String> keySet() {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                return jedis.exists(JedisMap.this.getKey()) != false ? jedis.hkeys(JedisMap.this.getKey()) : Collections.emptySet();
            }
        });
    }

    @Override
    public Collection<String> values() {
        return this.doWithJedis(new JedisCallable<Collection<String>>(){

            @Override
            public Collection<String> call(Jedis jedis) {
                return jedis.exists(JedisMap.this.getKey()) != false ? jedis.hvals(JedisMap.this.getKey()) : Collections.emptyList();
            }
        });
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.doWithJedis(new JedisCallable<Set<Map.Entry<String, String>>>(){

            @Override
            public Set<Map.Entry<String, String>> call(Jedis jedis) {
                return jedis.exists(JedisMap.this.getKey()) != false ? jedis.hgetAll(JedisMap.this.getKey()).entrySet() : Collections.emptySet();
            }
        });
    }
}

