/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils;

public class LexRange {
    private static final String MIN_INF = "-";
    private static final String MAX_INF = "+";
    private final String from;
    private final String to;
    private final int offset;
    private final int count;

    public LexRange(String from, String to, int offset, int count) {
        this.from = from;
        this.to = to;
        this.offset = offset;
        this.count = count;
        if (offset < 0 && count >= 0 || offset >= 0 && count < 0) {
            throw new IllegalArgumentException("offset and count must be both specified or not together");
        }
    }

    public String from() {
        return this.from;
    }

    public String fromReverse() {
        return MIN_INF.equals(this.from) ? MAX_INF : this.from;
    }

    public String to() {
        return this.to;
    }

    public String toReverse() {
        return MAX_INF.equals(this.to) ? MIN_INF : this.to;
    }

    public int offset() {
        return this.offset;
    }

    public int count() {
        return this.count;
    }

    public boolean hasLimit() {
        return this.offset >= 0 && this.count >= 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(String from, boolean inclusive) {
        return LexRange.builder().from(from, inclusive);
    }

    public static Builder fromInfinity() {
        return LexRange.builder().fromInfinity();
    }

    public static class Builder {
        private String from = "-";
        private String to = "+";
        private int offset = -1;
        private int count = -1;

        public Builder from(String from, boolean inclusive) {
            this.from = (inclusive ? "[" : "(") + from;
            return this;
        }

        public Builder fromInfinity() {
            this.from = LexRange.MIN_INF;
            return this;
        }

        public Builder to(String to, boolean inclusive) {
            this.to = (inclusive ? "[" : "(") + to;
            return this;
        }

        public Builder toInfinity() {
            this.to = LexRange.MAX_INF;
            return this;
        }

        public Builder limit(int offset, int count) {
            this.offset = offset;
            this.count = count;
            return this;
        }

        public LexRange build() {
            return new LexRange(this.from, this.to, this.offset, this.count);
        }
    }
}

