/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils.lua;

import java.util.LinkedHashMap;
import java.util.List;
import org.yatech.jedis.utils.lua.BasicLuaScript;
import org.yatech.jedis.utils.lua.LuaKeyArgument;
import org.yatech.jedis.utils.lua.LuaPreparedScript;
import org.yatech.jedis.utils.lua.LuaPreparedScriptUtils;
import org.yatech.jedis.utils.lua.LuaScriptConfig;
import org.yatech.jedis.utils.lua.LuaValueArgument;
import redis.clients.jedis.Jedis;

class BasicLuaPreparedScript
extends BasicLuaScript
implements LuaPreparedScript {
    private final LinkedHashMap<String, LuaKeyArgument> name2keyArguments;
    private final LinkedHashMap<String, LuaValueArgument> name2valueArguments;

    BasicLuaPreparedScript(String scriptText, List<LuaKeyArgument> keyArguments, List<LuaValueArgument> valueArguments, LuaScriptConfig config) {
        super(scriptText, config);
        this.name2keyArguments = LuaPreparedScriptUtils.toArgMap(keyArguments);
        this.name2valueArguments = LuaPreparedScriptUtils.toArgMap(valueArguments);
    }

    @Override
    public void setKeyArgument(String name, String key) {
        this.name2keyArguments.get(name).setValue(key);
    }

    @Override
    public void setValueArgument(String name, String value) {
        this.name2valueArguments.get(name).setValue(value);
    }

    @Override
    public void setValueArgument(String name, int value) {
        this.name2valueArguments.get(name).setValue(value);
    }

    @Override
    public void setValueArgument(String name, long value) {
        this.name2valueArguments.get(name).setValue(value);
    }

    @Override
    public void setValueArgument(String name, double value) {
        this.name2valueArguments.get(name).setValue(value);
    }

    @Override
    public Object exec(Jedis jedis) {
        return this.exec(jedis, LuaPreparedScriptUtils.toExecValues(this.name2keyArguments), LuaPreparedScriptUtils.toExecValues(this.name2valueArguments));
    }
}

