/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils.lua;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yatech.jedis.utils.lua.LuaArgument;

final class LuaPreparedScriptUtils {
    private LuaPreparedScriptUtils() {
    }

    static <T extends LuaArgument> LinkedHashMap<String, T> toArgMap(List<T> args) {
        LinkedHashMap<String, LuaArgument> map = new LinkedHashMap<String, LuaArgument>();
        if (args != null) {
            for (LuaArgument arg : args) {
                map.put(arg.getName(), arg.clone());
            }
        }
        return map;
    }

    static <T extends LuaArgument> List<String> toExecValues(Map<String, T> name2arguments) {
        ArrayList<String> values = new ArrayList<String>(name2arguments.size());
        for (Map.Entry<String, T> entry : name2arguments.entrySet()) {
            values.add(String.valueOf(((LuaArgument)entry.getValue()).getValue()));
        }
        return values;
    }

    static <T extends LuaArgument> LinkedHashMap<String, T> cloneArgMap(LinkedHashMap<String, T> source) {
        LinkedHashMap<String, LuaArgument> target = new LinkedHashMap<String, LuaArgument>(source.size());
        for (Map.Entry<String, T> sourceEntry : source.entrySet()) {
            target.put(sourceEntry.getKey(), ((LuaArgument)sourceEntry.getValue()).clone());
        }
        return target;
    }
}

