/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ClientInterceptor
public class ApiKeyHeaderDecorator
implements ClientExecutionInterceptor {
    private static Logger log = LoggerFactory.getLogger(ApiKeyHeaderDecorator.class);
    private String apiKey;
    private String username;
    private String ver;

    public ApiKeyHeaderDecorator() {
    }

    public ApiKeyHeaderDecorator(String username, String apiKey, String ver) {
        this.username = username;
        this.apiKey = apiKey;
        this.ver = ver;
    }

    public ClientResponse execute(ClientExecutionContext ctx) throws Exception {
        ctx.getRequest().getHeadersAsObjects().add((Object)"X-Auth-User", (Object)this.username);
        ctx.getRequest().getHeadersAsObjects().add((Object)"X-Auth-Token", (Object)this.apiKey);
        ctx.getRequest().getHeadersAsObjects().add((Object)"X-Version-No", (Object)this.ver);
        try {
            return ctx.proceed();
        }
        catch (Error e) {
            log.warn("error processing request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.warn("exception processing request", (Throwable)e);
            throw e;
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

